/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.table.katakana;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.table.TableHelper;
import java.awt.Color;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class KatakanaTableModel
extends AbstractTableModel {
    private static final int NUMBER_OF_COLUMNS = 10;
    private static final long serialVersionUID = 1L;
    private final Options options;
    private final List<Katakana> katakanaList;
    private final InternalKanaDataRequester requester;

    public KatakanaTableModel(Options options, List<Katakana> list, InternalKanaDataRequester internalKanaDataRequester) {
        this.options = options;
        this.katakanaList = list;
        this.requester = internalKanaDataRequester;
    }

    @Override
    public int getRowCount() {
        return this.katakanaList.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 9;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Katakana katakana = this.katakanaList.get(n);
        InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForKatakana(katakana);
        switch (n2) {
            case 0: {
                return n + 1;
            }
            case 1: {
                return katakana.getCharacter();
            }
            case 2: {
                return katakana.getHepburn();
            }
            case 3: {
                return katakana.getSubType().getDescription();
            }
            case 4: {
                return internalAdditionalKanaData.getTestCount();
            }
            case 5: {
                return internalAdditionalKanaData.getCorrectTestCount();
            }
            case 6: {
                return TableHelper.dateOrEmpty(internalAdditionalKanaData.getLastTestDate(), internalAdditionalKanaData.getTestCount());
            }
            case 7: {
                return TableHelper.dateOrEmpty(internalAdditionalKanaData.getLastCorrectTestDate(), internalAdditionalKanaData.getCorrectTestCount());
            }
            case 8: {
                return TableHelper.createMonospaceHtml(internalAdditionalKanaData.getLastTenTestResultsAsStorageString());
            }
            case 9: {
                return "Details";
            }
        }
        throw new RuntimeException("Unzul\u00e4siger Spaltenindex '" + n2 + "'.");
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 4: 
            case 5: 
            case 8: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
            case 6: 
            case 7: {
                return ImmutualDate.class;
            }
        }
        return String.class;
    }

    public Color determineRowForegroundColor(int n) {
        Katakana katakana = this.katakanaList.get(n);
        InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForKatakana(katakana);
        VocableColors vocableColors = new VocableColors(this.options);
        return vocableColors.determineKanaForegroundColor(internalAdditionalKanaData, true);
    }

    public Color determineRowBackgroundColor(int n) {
        Katakana katakana = this.katakanaList.get(n);
        InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForKatakana(katakana);
        VocableColors vocableColors = new VocableColors(this.options);
        return vocableColors.determineKanaBackgroundColor(internalAdditionalKanaData, true);
    }
}

