/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.testing;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.test.VocableListTesterLogic;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import de.duehl.vocabulary.japanese.ui.components.VocableTester;
import de.duehl.vocabulary.japanese.ui.components.data.VocableTestReactor;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.testing.AllTranslationsEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.testing.TranslationEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.testing.VocableAfterTypingErrorSelectorDialog;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class VocableListTesterDialog
extends ModalDialogBase
implements VocableTestReactor {
    private final List<Vocable> vocables;
    private final String testTitle;
    private final Options options;
    private final InternalDataRequester requester;
    private final VocableTester vocableTester;
    private final JButton quitButton;
    private final StringSelection numberOfVocablesSelection;
    private final StringSelection numberOfDoneVocablesSelection;
    private final StringSelection numberOfCorrectDoneVocablesSelection;
    private final StringSelection correctDonePercentVocablesSelection;
    private int numberOfDoneVocables;
    private int numberOfCorrectDoneVocables;
    private int indexOfShownVocable;
    private final VocableListTesterLogic logic;
    private final OwnLists ownLists;
    private final InternalKanjiDataRequester kanjiRequester;
    private final MessageSetter messageSetter;
    private final double lastTenTestsPercentBefore;

    public VocableListTesterDialog(List<Vocable> list, String string, Options options, InternalDataRequester internalDataRequester, VocableListTesterLogic vocableListTesterLogic, OwnLists ownLists, InternalKanjiDataRequester internalKanjiDataRequester, MessageSetter messageSetter, Point point, Image image) {
        super(point, image, VocableListTesterDialog.createDialogTitle(options, internalDataRequester, list, string));
        this.testTitle = string;
        this.options = options;
        this.requester = internalDataRequester;
        this.logic = vocableListTesterLogic;
        this.ownLists = ownLists;
        this.kanjiRequester = internalKanjiDataRequester;
        this.messageSetter = messageSetter;
        VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
        VocableListShuffler vocableListShuffler = new VocableListShuffler(options, list, vocablesShuffleType, internalDataRequester);
        vocableListShuffler.shuffle();
        this.vocables = vocableListShuffler.getVocables();
        this.vocableTester = new VocableTester(this, options);
        this.quitButton = new JButton();
        this.numberOfVocablesSelection = new StringSelection("Anzahl abzufragender Vokabeln");
        this.numberOfDoneVocablesSelection = new StringSelection("Anzahl bereits abgefragter Vokabeln");
        this.numberOfCorrectDoneVocablesSelection = new StringSelection("Anzahl korrekt beantworteter Vokabeln");
        this.correctDonePercentVocablesSelection = new StringSelection("Prozent korrekt beantworteter Vokabeln");
        this.lastTenTestsPercentBefore = VocabularyTrainerUiTools.createLastTenTestsPercent(options, internalDataRequester, list);
        this.fillDialog();
    }

    private static String createDialogTitle(Options options, InternalDataRequester internalDataRequester, List<Vocable> list, String string) {
        return VocabularyTrainerUiTools.generateTitleWithVocabularyTestSuccesss(options, internalDataRequester, list, string);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        this.showFirstVocable();
        this.keybindingsForPlaySound();
    }

    private void initElements() {
        SelectionsHelper.initSelectionAsViewer(this.numberOfVocablesSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfDoneVocablesSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfCorrectDoneVocablesSelection);
        SelectionsHelper.initSelectionAsViewer(this.correctDonePercentVocablesSelection);
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSummeryPart(), "North");
        jPanel.add(this.createVocabularyPart(), "Center");
        return jPanel;
    }

    private Component createSummeryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 3, 3));
        jPanel.add(this.numberOfVocablesSelection.getPanel());
        jPanel.add(this.numberOfDoneVocablesSelection.getPanel());
        jPanel.add(this.numberOfCorrectDoneVocablesSelection.getPanel());
        jPanel.add(this.correctDonePercentVocablesSelection.getPanel());
        return jPanel;
    }

    private Component createVocabularyPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.vocableTester.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPlaySoundKeyCombinationLabel(), "West");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createPlaySoundKeyCombinationLabel() {
        JLabel jLabel = new JLabel("Abspielen mit F9");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private void keybindingsForPlaySound() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(120, 0);
        String string = "F9";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.vocableTester.playMp3());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private Component createQuitButton() {
        this.quitButton.setText("Abbrechen");
        this.quitButton.addActionListener(actionEvent -> this.quit());
        return this.quitButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private void showFirstVocable() {
        this.numberOfVocablesSelection.setText(NumberString.taupu(this.vocables.size()));
        this.numberOfDoneVocables = 0;
        this.numberOfCorrectDoneVocables = 0;
        this.setNumbersAndPercent();
        this.indexOfShownVocable = 0;
        this.showVocable(this.vocables.get(this.indexOfShownVocable));
    }

    public void setNumbersAndPercent() {
        this.numberOfDoneVocablesSelection.setText(NumberString.taupu(this.numberOfDoneVocables));
        this.numberOfCorrectDoneVocablesSelection.setText(NumberString.taupu(this.numberOfCorrectDoneVocables));
        if (this.numberOfDoneVocables == 0) {
            this.correctDonePercentVocablesSelection.setText("0.00 %");
        } else {
            this.correctDonePercentVocablesSelection.setText(NumberString.percent(this.numberOfCorrectDoneVocables, this.numberOfDoneVocables) + " %");
        }
    }

    @Override
    public void userEnteredJapaneseToGermanTranslation(String string, String string2, String string3) {
        this.logic.userEnteredJapaneseToGermanTranslation(string, string2, string3);
    }

    @Override
    public void userEnteredGermanToJapaneseTranslation(String string, String string2) {
        this.logic.userEnteredGermanToJapaneseTranslation(string, string2);
    }

    public void increaseNumberOfDoneVocables() {
        ++this.numberOfDoneVocables;
    }

    public void increaseNumberOfCorrectDoneVocables() {
        ++this.numberOfCorrectDoneVocables;
    }

    public boolean informAboutTranslationSuccess(List<Vocable> list, boolean bl, Vocable vocable) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        if (bl) {
            arrayList.add(vocable);
        } else {
            arrayList.addAll(list);
        }
        TranslationEvaluationDialog translationEvaluationDialog = new TranslationEvaluationDialog(arrayList, bl, this.options.getTranslationDirection(), this.options, this.requester, this.ownLists, this.kanjiRequester, this.messageSetter, this.getLocation(), this.getProgramImage());
        translationEvaluationDialog.setVisible(true);
        if (bl) {
            return false;
        }
        return translationEvaluationDialog.wasOnlyTypingError();
    }

    @Override
    public void switchToNextVocable() {
        if (this.indexOfShownVocable < this.vocables.size() - 1) {
            ++this.indexOfShownVocable;
            this.showVocable(this.vocables.get(this.indexOfShownVocable));
            if (this.indexOfShownVocable == this.vocables.size() - 1) {
                this.quitButton.setText("Beenden");
            }
        } else {
            this.vocableTester.disable();
            SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
            double d = VocabularyTrainerUiTools.createLastTenTestsPercent(this.options, this.requester, this.vocables);
            String string = VocableListTesterDialog.createDialogTitle(this.options, this.requester, this.vocables, this.testTitle);
            AllTranslationsEvaluationDialog allTranslationsEvaluationDialog = new AllTranslationsEvaluationDialog(this.options, this.numberOfDoneVocables, this.numberOfCorrectDoneVocables, this.getLocation(), this.getProgramImage(), this.lastTenTestsPercentBefore, d, string);
            allTranslationsEvaluationDialog.setVisible(true);
            if (this.indexOfShownVocable == this.vocables.size() - 1) {
                this.closeDialog();
            }
        }
    }

    private void showVocable(Vocable vocable) {
        boolean bl = this.indexOfShownVocable + 1 == this.vocables.size();
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        this.vocableTester.showVocable(vocable, internalAdditionalVocableData, bl);
        this.getRealDialog().pack();
    }

    public Vocable letUserSelectMatchingVocableForHisTranslation(String string, List<Vocable> list) {
        VocableAfterTypingErrorSelectorDialog vocableAfterTypingErrorSelectorDialog = new VocableAfterTypingErrorSelectorDialog(string, list, this.requester, this.options, this.getLocation(), this.getProgramImage());
        vocableAfterTypingErrorSelectorDialog.setVisible(true);
        if (vocableAfterTypingErrorSelectorDialog.hasUserSelected()) {
            return vocableAfterTypingErrorSelectorDialog.getCorrectVocable();
        }
        GuiTools.informUser(this.quitButton, "Abbruch bei der Auswahl", "Da die Auswahl abgebrochen wurde, schreiben wir die richige \u00dcbersetzung der ersten angezeigten Vokabel gut.");
        return list.get(0);
    }

    @Override
    public boolean doWeHaveToReactOnEmptyTranslation() {
        return this.logic.doWeHaveToReactOnEmptyTranslation();
    }
}

