/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.listcommander;

import de.duehl.twosidecommander.ui.TwoSideCommander;
import de.duehl.twosidecommander.ui.list.ListDisplayer;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.dialog.detail.VocableWithInternaDialog;
import de.duehl.vocabulary.japanese.ui.listcommander.list.OwnListDisplayer;
import de.duehl.vocabulary.japanese.ui.listcommander.selector.OwnListSelector;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OwnListCommander
extends TwoSideCommander {
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private OwnListSelector leftSelector;
    private OwnListSelector rightSelector;
    private OwnListDisplayer leftListDisplayer;
    private OwnListDisplayer rightListDisplayer;

    public OwnListCommander(VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui) {
        super("Listen-Commander", vocabularyTrainerGui.getLocation(), vocabularyTrainerGui.getProgramImage());
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
    }

    public void start() {
        this.createAndInitListDisplayer();
        this.createAndSetOwnListSelectors();
        this.enableToggableMovingButtons();
        this.createAndSetMiddleBarButtons();
        this.createGui();
        this.setOwnKeyBindings();
        this.setVisible(true);
    }

    private void createAndInitListDisplayer() {
        this.leftListDisplayer = new OwnListDisplayer(this);
        this.setLeftListDisplayer(this.leftListDisplayer);
        this.rightListDisplayer = new OwnListDisplayer(this);
        this.setRightListDisplayer(this.rightListDisplayer);
    }

    private void createAndSetOwnListSelectors() {
        Options options = this.logic.getOptions();
        this.leftSelector = new OwnListSelector(this.logic.getOwnLists(), ownList -> this.leftOwnListChanged(ownList), options.getHistoricalLeftOwnListsInListCommander(), this.getLocation(), this.getProgramImage());
        this.setLeftListSelector(this.leftSelector);
        this.rightSelector = new OwnListSelector(this.logic.getOwnLists(), ownList -> this.rightOwnListChanged(ownList), options.getHistoricalRightOwnListsInListCommander(), this.getLocation(), this.getProgramImage());
        this.setRightListSelector(this.rightSelector);
    }

    private void leftOwnListChanged(OwnList ownList) {
        this.ownListChanged(this.leftListDisplayer, ownList);
        Options options = this.logic.getOptions();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = options.getHistoricalLeftOwnListsInListCommander();
        historicalOwnListPersistanceDataList.addOwnListData(ownList.toOwnListPersistanceData());
    }

    private void rightOwnListChanged(OwnList ownList) {
        this.ownListChanged(this.rightListDisplayer, ownList);
        Options options = this.logic.getOptions();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = options.getHistoricalRightOwnListsInListCommander();
        historicalOwnListPersistanceDataList.addOwnListData(ownList.toOwnListPersistanceData());
    }

    private void ownListChanged(OwnListDisplayer ownListDisplayer, OwnList ownList) {
        ownListDisplayer.setOwnList(ownList);
        ownListDisplayer.readAndShowList();
    }

    private void createAndSetMiddleBarButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createEditActiveListButton());
        jPanel.add(this.createNewListButton());
        this.setMiddleButtonBar(jPanel);
    }

    private Component createEditActiveListButton() {
        JButton jButton = new JButton("<html><center>F3 - Aktive Liste<br>bearbeiten</center></html>");
        jButton.addActionListener(actionEvent -> this.editActiveList());
        return jButton;
    }

    private void editActiveList() {
        ListDisplayer listDisplayer = this.getActiveListDisplayer();
        OwnListDisplayer ownListDisplayer = OwnListDisplayer.castListDisplayer(listDisplayer);
        OwnList ownList = ownListDisplayer.getOwnList();
        boolean bl = this.gui.editOwnList(ownList);
        if (bl) {
            listDisplayer.readAndShowList();
            this.leftSelector.refillComboboxes();
            this.rightSelector.refillComboboxes();
        }
    }

    private Component createNewListButton() {
        JButton jButton = new JButton("<html><center>F4 - Neue Liste<br>anlegen</center></html>");
        jButton.addActionListener(actionEvent -> this.createNewList());
        return jButton;
    }

    private void createNewList() {
        boolean bl = this.gui.createNewOwnList();
        if (bl) {
            this.leftSelector.refillComboboxes();
            this.rightSelector.refillComboboxes();
        }
    }

    private void setOwnKeyBindings() {
        this.setKeyBindingF3(() -> this.editActiveList());
        this.setKeyBindingF4(() -> this.createNewList());
    }

    public void showVocableDetails(Vocable vocable) {
        VocableWithInternaDialog vocableWithInternaDialog = new VocableWithInternaDialog(this.logic.getOptions(), this.logic.getInternalDataRequester(), vocable, this.logic.getOwnLists(), this.logic.getInternalKanjiDataRequester(), string -> this.gui.setMessageLater(string), this.getLocation(), this.gui.getProgramImage());
        vocableWithInternaDialog.setVisible(true);
    }

    public void storeOwnLists() {
        OwnLists ownLists = this.logic.getOwnLists();
        ownLists.storeOwnLists();
    }
}

