/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.listcommander.selector;

import de.duehl.swing.ui.buttons.painted.DownButton;
import de.duehl.twosidecommander.ui.color.ListCommanderColors;
import de.duehl.twosidecommander.ui.selector.ListSelector;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.listcommander.selector.OwnListSelectionChangeInformer;
import de.duehl.vocabulary.japanese.ui.listcommander.selector.history.OwnListHistoryDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OwnListSelector
extends ListSelector {
    private final OwnLists ownLists;
    private final OwnListSelectionChangeInformer informer;
    private final HistoricalOwnListPersistanceDataList historicalOwnLists;
    private final Point parentLocation;
    private final Image programImage;
    private final JComboBox<String> categoryFilterComboBox;
    private final JComboBox<String> subCategoryFilterComboBox;
    private final JComboBox<String> nameComboBox;
    private final DownButton historicButton;
    private final JPanel panel;
    private boolean actualiseSelectedName;

    public OwnListSelector(OwnLists ownLists, OwnListSelectionChangeInformer ownListSelectionChangeInformer, HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList, Point point, Image image) {
        this.ownLists = ownLists;
        this.informer = ownListSelectionChangeInformer;
        this.historicalOwnLists = historicalOwnListPersistanceDataList;
        this.parentLocation = point;
        this.programImage = image;
        this.categoryFilterComboBox = new JComboBox();
        this.subCategoryFilterComboBox = new JComboBox();
        this.nameComboBox = new JComboBox();
        this.historicButton = new DownButton();
        this.panel = new JPanel();
        this.actualiseSelectedName = true;
        this.init();
        this.fillPanel();
    }

    private void init() {
        this.initComboBoxes();
        this.fillComboBoxes();
        this.selectLastUsedOwnListInComboBoxes();
        this.isUsed();
        this.addComboboxesActionListeners();
        this.initHistoricButton();
    }

    private void initComboBoxes() {
        OwnListSelector.initComboBox(this.categoryFilterComboBox);
        OwnListSelector.initComboBox(this.subCategoryFilterComboBox);
        OwnListSelector.initComboBox(this.nameComboBox);
    }

    private static void initComboBox(JComboBox<String> jComboBox) {
        jComboBox.setAlignmentX(0.0f);
        jComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)jComboBox.getRenderer())).setHorizontalAlignment(0);
        jComboBox.setFocusable(false);
    }

    private void fillComboBoxes() {
        this.fillCategoryComboBox();
        this.fillSubCategoryComboBox();
        this.fillNameComboBox();
    }

    private void fillCategoryComboBox() {
        this.categoryFilterComboBox.removeAllItems();
        for (String string : VocabularyTools.determineCategories(this.ownLists.getOwnLists())) {
            this.categoryFilterComboBox.addItem(string);
        }
    }

    private void fillSubCategoryComboBox() {
        this.subCategoryFilterComboBox.removeAllItems();
        String string = (String)this.categoryFilterComboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        List<String> list = VocabularyTools.determineSubCategoriesOfCategory(this.ownLists.getOwnLists(), string);
        for (String string2 : list) {
            this.subCategoryFilterComboBox.addItem(string2);
        }
    }

    private void fillNameComboBox() {
        this.nameComboBox.removeAllItems();
        String string = (String)this.categoryFilterComboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        String string2 = (String)this.subCategoryFilterComboBox.getSelectedItem();
        if (string2 == null) {
            return;
        }
        List<OwnList> list = this.ownLists.findOwnListsWithCategoryAndSubCategory(string, string2);
        OwnLists.sortListsByName(list);
        for (OwnList ownList : list) {
            String string3 = ownList.getName();
            this.nameComboBox.addItem(string3);
        }
    }

    private void selectLastUsedOwnListInComboBoxes() {
        OwnListPersistanceData ownListPersistanceData;
        List<OwnListPersistanceData> list = this.historicalOwnLists.getHistoricalOwnLists();
        if (!list.isEmpty() && (ownListPersistanceData = list.get(list.size() - 1)).isInitialised() && this.ownLists.containsOwnList(ownListPersistanceData)) {
            String string = ownListPersistanceData.getCategory();
            String string2 = ownListPersistanceData.getSubCategory();
            String string3 = ownListPersistanceData.getName();
            this.categoryFilterComboBox.setSelectedItem(string);
            this.fillSubCategoryComboBox();
            this.subCategoryFilterComboBox.setSelectedItem(string2);
            this.fillNameComboBox();
            this.nameComboBox.setSelectedItem(string3);
            OwnList ownList = this.ownLists.findByName(string3);
            if (!ownList.equals(OwnLists.NO_OWN_LIST_FOUND)) {
                this.informer.ownListSelected(ownList);
            }
        }
    }

    private void addComboboxesActionListeners() {
        this.categoryFilterComboBox.addActionListener(actionEvent -> this.categorySelectionChanged());
        this.subCategoryFilterComboBox.addActionListener(actionEvent -> this.subCategorySelectionChanged());
        this.nameComboBox.addActionListener(actionEvent -> this.nameSelectionChanged());
    }

    private void categorySelectionChanged() {
        if (this.actualiseSelectedName) {
            this.fillSubCategoryComboBox();
            this.fillNameComboBox();
            this.isUsed();
        }
    }

    private void subCategorySelectionChanged() {
        if (this.actualiseSelectedName) {
            this.fillNameComboBox();
            this.isUsed();
        }
    }

    private void nameSelectionChanged() {
        if (this.actualiseSelectedName) {
            String string = (String)this.nameComboBox.getSelectedItem();
            if (null == string) {
                return;
            }
            OwnList ownList = this.ownLists.findByName(string);
            if (!ownList.equals(OwnLists.NO_OWN_LIST_FOUND)) {
                this.informer.ownListSelected(ownList);
            }
            this.isUsed();
        }
    }

    private void initHistoricButton() {
        this.historicButton.forceSquare();
        this.historicButton.setPreferredSize(new Dimension(35, 1));
        this.historicButton.addActionListener(actionEvent -> this.showHistory());
    }

    private void showHistory() {
        if (!this.historicalOwnLists.isEmpty()) {
            Point point = this.panel.getLocation();
            Point point2 = this.historicButton.getLocation();
            Point point3 = new Point(this.parentLocation.x + point.x + point2.x + 150, this.parentLocation.y + point.y + point2.y + 100);
            OwnListHistoryDialog ownListHistoryDialog = new OwnListHistoryDialog(this.historicalOwnLists, point3, this.programImage);
            ownListHistoryDialog.setVisible(true);
            if (ownListHistoryDialog.isValidSelection()) {
                OwnListPersistanceData ownListPersistanceData = ownListHistoryDialog.getSelectedPersistentOwnList();
                this.historicalOwnLists.addOwnListData(ownListPersistanceData);
                this.actualiseSelectedName = false;
                this.selectLastUsedOwnListInComboBoxes();
                this.actualiseSelectedName = true;
            }
        }
        this.isUsed();
    }

    private void fillPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createComboBoxesPart(), "Center");
        this.panel.add((Component)this.historicButton, "East");
    }

    private Component createComboBoxesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createCategoryComboBoxesPart(), "North");
        jPanel.add(this.nameComboBox, "South");
        return jPanel;
    }

    private Component createCategoryComboBoxesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 2, 2));
        jPanel.add(this.categoryFilterComboBox);
        jPanel.add(this.subCategoryFilterComboBox);
        return jPanel;
    }

    @Override
    public final JPanel getPanel() {
        return this.panel;
    }

    @Override
    public final void showActive() {
        this.setComboBoxBackgroundColors(ListCommanderColors.ACTIVE_COMBOBOX_BACKGROUND_COLOR);
    }

    @Override
    public final void showInactive() {
        this.setComboBoxBackgroundColors(ListCommanderColors.INACTIVE_COMBOBOX_BACKGROUND_COLOR);
    }

    private void setComboBoxBackgroundColors(Color color) {
        this.categoryFilterComboBox.setBackground(color);
        this.subCategoryFilterComboBox.setBackground(color);
        this.nameComboBox.setBackground(color);
    }

    public void refillComboboxes() {
        this.removeComboboxesActionListeners();
        this.fillComboBoxes();
        this.selectLastUsedOwnListInComboBoxes();
        this.nameSelectionChanged();
        this.addComboboxesActionListeners();
    }

    private void removeComboboxesActionListeners() {
        this.removeAllActionListeners(this.categoryFilterComboBox);
        this.removeAllActionListeners(this.subCategoryFilterComboBox);
        this.removeAllActionListeners(this.nameComboBox);
    }

    private void removeAllActionListeners(JComboBox<String> jComboBox) {
        for (ActionListener actionListener : jComboBox.getActionListeners()) {
            jComboBox.removeActionListener(actionListener);
        }
    }
}

