/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.sort;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.io.ManualVocabularySortOrderFileIo;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class VocabularyBarSorter {
    private final List<VocabularyBar> vocabularyBars;
    private final VocabularySortOrder sortOrder;
    private List<String> manualSortedDescriptions;

    public VocabularyBarSorter(List<VocabularyBar> list, VocabularySortOrder vocabularySortOrder) {
        this.vocabularyBars = list;
        this.sortOrder = vocabularySortOrder;
        this.manualSortedDescriptions = new ArrayList<String>();
    }

    public void sort() {
        this.readManualSortOrderIfNeeded();
        this.sortInternal();
    }

    private void readManualSortOrderIfNeeded() {
        if (this.sortOrder == VocabularySortOrder.MANUAL_SORT_ORDER) {
            if (this.isSortingOwnListsBars()) {
                List<String> list = OwnLists.readOwnListNames();
                List<String> list2 = this.namesToDescriptions(list);
                this.manualSortedDescriptions = list2;
            } else {
                this.manualSortedDescriptions = ManualVocabularySortOrderFileIo.readManualVocabularyDescriptionsOrder();
            }
        }
    }

    private List<String> namesToDescriptions(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = OwnList.createDescriptionFromName(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean isSortingOwnListsBars() {
        VocabularyBar vocabularyBar = this.vocabularyBars.get(0);
        return vocabularyBar.isOwnListsBar();
    }

    private void sortInternal() {
        Collections.sort(this.vocabularyBars, new Comparator<VocabularyBar>(){

            @Override
            public int compare(VocabularyBar vocabularyBar, VocabularyBar vocabularyBar2) {
                return VocabularyBarSorter.this.compareInternal(vocabularyBar, vocabularyBar2);
            }
        });
    }

    private int compareInternal(VocabularyBar vocabularyBar, VocabularyBar vocabularyBar2) {
        switch (this.sortOrder) {
            case ALPHABETICAL: {
                return this.compareAlphabetical(vocabularyBar, vocabularyBar2);
            }
            case REVERSED_ALPHABETICAL: {
                return -this.compareAlphabetical(vocabularyBar, vocabularyBar2);
            }
            case OLDEST_VOCABULARIES_FIRST: {
                return this.compareNewestFirst(vocabularyBar, vocabularyBar2);
            }
            case NEWEST_VOCABULARIES_FIRST: {
                return -this.compareNewestFirst(vocabularyBar, vocabularyBar2);
            }
            case MANUAL_SORT_ORDER: {
                return this.compareByManualOrder(vocabularyBar, vocabularyBar2);
            }
        }
        throw new RuntimeException("Unbekannte Sortierreihenfolge '" + this.sortOrder + ".");
    }

    private int compareAlphabetical(VocabularyBar vocabularyBar, VocabularyBar vocabularyBar2) {
        String string = vocabularyBar.getVocabulary().getDescription();
        String string2 = vocabularyBar2.getVocabulary().getDescription();
        return Text.compareStringsBetter(string, string2);
    }

    private int compareNewestFirst(VocabularyBar vocabularyBar, VocabularyBar vocabularyBar2) {
        ImmutualDate immutualDate;
        ImmutualDate immutualDate2 = vocabularyBar.getVocabulary().getFirstSeenDate();
        if (immutualDate2.after(immutualDate = vocabularyBar2.getVocabulary().getFirstSeenDate())) {
            return 1;
        }
        if (immutualDate2.before(immutualDate)) {
            return -1;
        }
        return this.compareAlphabetical(vocabularyBar, vocabularyBar2);
    }

    private int compareByManualOrder(VocabularyBar vocabularyBar, VocabularyBar vocabularyBar2) {
        String string = vocabularyBar.getVocabulary().getDescription();
        String string2 = vocabularyBar2.getVocabulary().getDescription();
        if (this.manualSortedDescriptions.contains(string) && this.manualSortedDescriptions.contains(string2)) {
            int n = this.manualSortedDescriptions.indexOf(string);
            int n2 = this.manualSortedDescriptions.indexOf(string2);
            return n - n2;
        }
        if (this.manualSortedDescriptions.contains(string)) {
            return -1;
        }
        if (this.manualSortedDescriptions.contains(string2)) {
            return 1;
        }
        return 0;
    }
}

