package de.duehl.basics.exceptions;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Ausnahmeklasse für das falsche Quellformat.
 *
 * @version 1.01     2016-01-26
 * @author Christian Dühl
 */

public class WrongSourceFormatException extends RuntimeException {

    private static final long serialVersionUID = 1268830144340290905L;

    /**
     * Konstruktor
     *
     * @param errorMessage
     *            Text der Fehlermeldung.
     */
    public WrongSourceFormatException(String errorMessage) {
        super(errorMessage);
    }

    /**
     * Konstruktor
     *
     * @param errorMessage
     *            Text der Fehlermeldung.
     * @param exception
     *            Aufgetretene Ausnahme.
     */
    public WrongSourceFormatException(String errorMessage, Exception exception) {
        super(errorMessage, exception);
    }

}
