package de.duehl.basics.history;

public interface HistoryStateDisplayer {

    /**
     * Lässt die Benutzung z.B. des Buttons und des Menüeintrags für den vorigen Stand aus der
     * Bearbeitungshistorie zu.
     */
    void enableUndo();

    /**
     * Verbietet die Benutzung z.B. des Buttons und des Menüeintrags für den vorigen Stand aus der
     * Bearbeitungshistorie.
     */
    void disableUndo();

    /**
     * Lässt die Benutzung z.B. des Buttons und des Menüeintrags für den nächsten Stand aus der
     * Bearbeitungshistorie zu.
     */
    void enableRedo();

    /**
     * Verbietet die Benutzung z.B. des Buttons und des Menüeintrags für den nächsten Stand aus der
     * Bearbeitungshistorie.
     */
    void disableRedo();

}
