package de.duehl.basics.io.walker;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;

public class TablePrintingDirWalkerObserver implements DirWalkerObserver {

    private final String systemDisplayName;

    public TablePrintingDirWalkerObserver(String startDir) {
        systemDisplayName = FileHelper.getSystemDisplayName(startDir);
        printTitles();
    }

    private void printTitles() {
        List<String> titleParts = CollectionsHelper.buildListFrom("System Display Name",
                "Bemerkung", "Pfad");
        printFields(titleParts);
    }

    @Override
    public void visitFile(String fileName) {
        printLine("Datei", fileName);
    }

    @Override
    public void visitEmptyDir(String dirName) {
        printLine("leeres Verzeichnis", dirName);
    }

    private void printLine(String comment, String path) {
        List<String> lineParts = CollectionsHelper.buildListFrom(systemDisplayName, comment, path);
        printFields(lineParts);
    }

    private void printFields(List<String> parts) {
        System.out.println(Text.joinWithTabulator(parts));
    }

    @Override
    public void visitNotEmptyDir(String dirName) {
        // für diese wird nichts gemacht...
    }

}
