package de.duehl.basics.logic;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.Map;

import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.FineFileWriter;

/**
 * Diese Klasse führt ein einfaches Templating per Suchen und Ersetzen durch.
 * Die Templating-Begriffe in translations müssen im Quellcode mit '@@' umgeben
 * werden. Z.B. passt '@@DAY@@' zum key 'DAY'.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public class SimpleTemplating {

    /**
     * Führt die Umsetzung einer Datei durch.
     *
     * @param inputFile
     *            Eingabedatei (source, Datei mit @@PLATZHALTER@@)
     * @param outputFile
     *            Ausgabedatei (lauffähiger sas-Code)
     * @param translations
     *            Map mit den Übersetzungen ("DAY" -> "20130416_073").
     */
    public void template(final String inputFile, final String outputFile,
            final Map<String, String> translations) {
        FineFileReader reader = new FineFileReader(inputFile);
        FineFileWriter writer = new FineFileWriter(outputFile);
        String line = reader.readNextLine();
        while (line != null) {
            line = templateString(line, translations);
            writer.writeln(line);

            line = reader.readNextLine();
        }
        writer.close();
        reader.close();
    }

    /**
     * Führt die Umsetzung einer Zeile durch.
     *
     * @param line
     *            Zu bearbeitende Zeile.
     * @param translations
     *            Map mit den Übersetzungen ("DAY" -> "20130416_073").
     * @return Veränderte Zeile.
     */
    public String templateString(final String line,
            final Map<String, String> translations) {
        String changedLine = line;
        for (String key : translations.keySet()) {
            String search = "@@" + key + "@@";
            String replace = translations.get(key);
            changedLine = changedLine.replace(search, replace);
        }
        return changedLine;
    }

}
