package de.duehl.basics.random;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.Random;

/**
 * Diese Klasse bietet Methoden, Zahlen zufällig leicht abzuwandeln.
 *
 * @version 1.01     2017-06-22
 * @author Christian Dühl
 */

public class Randomizer {

    private final Random random;

    public Randomizer() {
        random = new Random();
    }

    /**
     * Variiert die Zahl leicht, es wird eine im Bereich von 90% bis zu 110% der Ausgangszahl
     * zurückgegeben.
     */
    public long randomizeFrom90To110Percent(long number) {
        long tenPercent = number / 10L;
        if (tenPercent < 1L) {
            tenPercent = 1L;
        }
        double randomPercent = random.nextDouble();
        long base = number - tenPercent;
        double varying = randomPercent * 2L * tenPercent;
        long varyingRounded = Math.round(varying);
        long milliesToSleep = base + varyingRounded;

        return milliesToSleep;
    }

}
