package de.duehl.basics.autodetect;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.autodetect.ent.single.SingleEntityReplacer;
import de.duehl.basics.autodetect.ent.single.SingleEntityReplacerViaIntroList;
import de.duehl.basics.collections.CollectionsHelper;

public class SingleEntityReplacerTest {

    private static final List<String> OBST_BEGINNINGS = CollectionsHelper.buildListFrom("Obst:");
    private static final List<String> OBST = CollectionsHelper.buildListFrom("Apfel", "Birne");

    @Test
    public void createEntityString() {
        String ent = "In der Schüssel liegt ein Obst: Apfel und ein steinernes Ei.";

        String placeholder = "<<obst>>";
        String additionalAutoComment = "[obst]";

        SingleEntityReplacer replacer = new SingleEntityReplacerViaIntroList(ent, OBST_BEGINNINGS,
                placeholder, additionalAutoComment, e -> findAtStart(e));
        replacer.replace();

        String obst = replacer.getValue();
        assertEquals("Apfel", obst);

        String actualEnt = replacer.getEnt();
        String expectedEnt = "In der Schüssel liegt ein <<obst>> und ein steinernes Ei.";
        assertEquals(expectedEnt, actualEnt);

        String actualAutoComment = replacer.getAutoComment();
        String expectedAutoComment = "[obst]";
        assertEquals(expectedAutoComment, actualAutoComment);
    }

    /**
     * Ermittelt, ob der übergebene String mit einer Ausprägung des gewünschten Begriffs beginnt.
     * Tut er das nicht, wird der leere String zurückgegeben, anderenfalls der erkannte Wert.
     */
    private String findAtStart(String text) {
        for (String obst : OBST) {
            if (text.startsWith(obst)) {
                return obst;
            }
        }

        return "";
    }

}
