package de.duehl.basics.datetime.date;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.datetime.time.watch.StopWatch;

public class DateDifferenceTimeTest {

    public void run() {
        List<ImmutualDate> dates = createDateList();
        System.out.println("Anzahl Datumswerte: " + dates.size());

        System.out.println("\nTest calculateDayDistanceTo()");
        StopWatch watch1 = new StopWatch();
        for (ImmutualDate date1 : dates) {
            for (ImmutualDate date2 : dates) {
                int abstand1 = date1.calculateDayDistanceTo(date2);
                int abstand2 = date2.calculateDayDistanceTo(date1);
                if (abstand1 != -abstand2) {
                    System.err.println("Fehler bei date1 = " + date1
                            + ", date2 = " + date2
                            + " calculateDayDistanceTo()");
                }
            }
        }
        System.out.println("calculateDayDistanceTo(): " + watch1.getTime());

        System.out.println("\nTest calculateDayDifference()");
        StopWatch watch2 = new StopWatch();
        for (ImmutualDate date1 : dates) {
            for (ImmutualDate date2 : dates) {
                int abstand1 = date1.calculateDayDifference(date2);
                int abstand2 = date2.calculateDayDifference(date1);
                if (abstand1 != -abstand2) {
                    System.err.println("Fehler bei date1 = " + date1
                            + ", date2 = " + date2
                            + " calculateDayDifference()");
                }
            }
        }
        System.out.println("calculateDayDifference(): " + watch2.getTime());
    }

    public static List<ImmutualDate> createDateList() {
        List<ImmutualDate> list = new ArrayList<>();

        for (int year=1895; year<=2020; ++year) {
            for (int month=1; month<=12; ++month) {
                for (int day=1; day<=31; ++day) {
                    ImmutualDate date = new ImmutualDate(day, month, year);
                    if (date.isValid()) {
                        list.add(date);
                    }
                }
            }
        }

        return list;
    }

    public static void main(String[] args) {
        new DateDifferenceTimeTest().run();
    }

}
