package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.datetime.date.ImmutualDate;

public class DateParseMethodSlashTest {

    @Test
    public void parseNormalCase() {
        DateParseMethod method = new DateParseMethodSlash("1967/02/11");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(11, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(1967, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseWithOneDigitMonth() {
        DateParseMethod method = new DateParseMethodSlash("2013/8/22");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(22, date.getDay());
        assertEquals(8, date.getMonth());
        assertEquals(2013, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseOneDigitMonthOneDigitDay() {
        DateParseMethod method = new DateParseMethodSlash("2013/8/2");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(2, date.getDay());
        assertEquals(8, date.getMonth());
        assertEquals(2013, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseOneDigitDay() {
        DateParseMethod method = new DateParseMethodSlash("2013/12/6");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(6, date.getDay());
        assertEquals(12, date.getMonth());
        assertEquals(2013, date.getYear());

        assertTrue(date.isValid());
    }

}
