package de.duehl.basics.io;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;

import org.junit.Test;

import de.duehl.basics.test.TestHelper;

public class BatchFileWithOwnJarActualiserTest {

    private final String path;

    public BatchFileWithOwnJarActualiserTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 6);
        path =  testHelper.getTestDataPath() + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void fileSizeExisting() {
        String dir = FileHelper.concatPathes(path, "batchFileActualiser");
        FileHelper.deleteTree(dir);
        FileHelper.createDirectoryIfNotExists(dir);

        String batFilename = FileHelper.concatPathes(dir, "demo_batch_1.bat");
        String cmdFilename = FileHelper.concatPathes(dir, "demo_batch_2.cmd");

        String content = """
                @echo off
                set jar=c:\\foo\\bar\\baz\\de.duehl.demo_projekt_0.0.1.jar
                """;

        FileHelper.writeTextToFile(content, batFilename);
        FileHelper.writeTextToFile(content, cmdFilename);

        String name = "de.duehl.demo_projekt";
        String version = "0.0.2";
        BatchFileWithOwnJarActualiser actualiser = new BatchFileWithOwnJarActualiser(dir, name,
                version);
        actualiser.actualize();
        List<String> actualisedFilenames = actualiser.getActualisedFilenames();
        assertEquals(2, actualisedFilenames.size());
        assertTrue(actualisedFilenames.contains(batFilename));
        assertTrue(actualisedFilenames.contains(cmdFilename));

        List<String> batLines = FileHelper.readFileToList(batFilename);
        List<String> cmdLines = FileHelper.readFileToList(cmdFilename);
        assertEquals(3, batLines.size());
        assertEquals(3, cmdLines.size());

        String batLine = batLines.get(1);
        String cmdLine = cmdLines.get(1);

        assertEquals("set jar=c:\\foo\\bar\\baz\\de.duehl.demo_projekt_0.0.2.jar", batLine);
        assertEquals("set jar=c:\\foo\\bar\\baz\\de.duehl.demo_projekt_0.0.2.jar", cmdLine);
    }

}
