package de.duehl.basics.replacements;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;
import java.util.Map;

import org.junit.Test;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.replacements.data.FoundPlaceholder;

public class ReplacementsAnalyserTest {

     @Test
     public void test001() {
         String text = ""
                 + "Auf Grund des Verschmelzungsvertrages vom <<date:1>> und der "
                 + "Zustimmungsbeschlüsse ist die <<company-name:1>> mit Sitz in <<town:1>> "
                 + "<<amtsgericht:1>> <<uebertragend:1>> "
                 + ""
                 + "Auf Grund des Verschmelzungsvertrages vom <<date:2>> und der "
                 + "Zustimmungsbeschlüsse ist die <<company-name:2>> mit Sitz in <<town:2>> "
                 + "<<amtsgericht:2>> <<uebertragend:2>> "
                 + ""
                 + "Auf Grund des Verschmelzungsvertrages vom <<date:3>> und der "
                 + "Zustimmungsbeschlüsse ist die <<company-name:3>> mit Sitz in <<town:3>> "
                 + "<<amtsgericht:3>> <<uebertragend:3>>";
         ReplacementsAnalyser analyser = new ReplacementsAnalyser(text);
         analyser.analyse();
         List<FoundPlaceholder> foundPlaceholders = analyser.getFoundPlaceholders();
         assertEquals(15, foundPlaceholders.size());
         FoundPlaceholder foundPlaceholder01 = foundPlaceholders.get( 0);
         FoundPlaceholder foundPlaceholder02 = foundPlaceholders.get( 1);
         FoundPlaceholder foundPlaceholder03 = foundPlaceholders.get( 2);
         FoundPlaceholder foundPlaceholder04 = foundPlaceholders.get( 3);
         FoundPlaceholder foundPlaceholder05 = foundPlaceholders.get( 4);
         FoundPlaceholder foundPlaceholder06 = foundPlaceholders.get( 5);
         FoundPlaceholder foundPlaceholder07 = foundPlaceholders.get( 6);
         FoundPlaceholder foundPlaceholder08 = foundPlaceholders.get( 7);
         FoundPlaceholder foundPlaceholder09 = foundPlaceholders.get( 8);
         FoundPlaceholder foundPlaceholder10 = foundPlaceholders.get( 9);
         FoundPlaceholder foundPlaceholder11 = foundPlaceholders.get(10);
         FoundPlaceholder foundPlaceholder12 = foundPlaceholders.get(11);
         FoundPlaceholder foundPlaceholder13 = foundPlaceholders.get(12);
         FoundPlaceholder foundPlaceholder14 = foundPlaceholders.get(13);
         FoundPlaceholder foundPlaceholder15 = foundPlaceholders.get(14);

         assertEquals( 42, foundPlaceholder01.getIndex());
         assertEquals("<<date:1>>", foundPlaceholder01.getPlaceholder());
         assertEquals("date", foundPlaceholder01.getName());
         assertEquals(1, foundPlaceholder01.getPosition());
         assertEquals("", foundPlaceholder01.getReplacedText());

         assertEquals( 91, foundPlaceholder02.getIndex());
         assertEquals("<<company-name:1>>", foundPlaceholder02.getPlaceholder());
         assertEquals("company-name", foundPlaceholder02.getName());
         assertEquals(1, foundPlaceholder02.getPosition());
         assertEquals("", foundPlaceholder02.getReplacedText());

         assertEquals(122, foundPlaceholder03.getIndex());
         assertEquals("<<town:1>>", foundPlaceholder03.getPlaceholder());
         assertEquals("town", foundPlaceholder03.getName());
         assertEquals(1, foundPlaceholder03.getPosition());
         assertEquals("", foundPlaceholder03.getReplacedText());

         assertEquals(133, foundPlaceholder04.getIndex());
         assertEquals("<<amtsgericht:1>>", foundPlaceholder04.getPlaceholder());
         assertEquals("amtsgericht", foundPlaceholder04.getName());
         assertEquals(1, foundPlaceholder04.getPosition());
         assertEquals("", foundPlaceholder04.getReplacedText());

         assertEquals(151, foundPlaceholder05.getIndex());
         assertEquals("<<uebertragend:1>>", foundPlaceholder05.getPlaceholder());
         assertEquals("uebertragend", foundPlaceholder05.getName());
         assertEquals(1, foundPlaceholder05.getPosition());
         assertEquals("", foundPlaceholder05.getReplacedText());

         assertEquals(212, foundPlaceholder06.getIndex());
         assertEquals("<<date:2>>", foundPlaceholder06.getPlaceholder());
         assertEquals("date", foundPlaceholder06.getName());
         assertEquals(2, foundPlaceholder06.getPosition());
         assertEquals("", foundPlaceholder06.getReplacedText());

         assertEquals(261, foundPlaceholder07.getIndex());
         assertEquals("<<company-name:2>>", foundPlaceholder07.getPlaceholder());
         assertEquals("company-name", foundPlaceholder07.getName());
         assertEquals(2, foundPlaceholder07.getPosition());
         assertEquals("", foundPlaceholder07.getReplacedText());

         assertEquals(292, foundPlaceholder08.getIndex());
         assertEquals("<<town:2>>", foundPlaceholder08.getPlaceholder());
         assertEquals("town", foundPlaceholder08.getName());
         assertEquals(2, foundPlaceholder08.getPosition());
         assertEquals("", foundPlaceholder08.getReplacedText());

         assertEquals(303, foundPlaceholder09.getIndex());
         assertEquals("<<amtsgericht:2>>", foundPlaceholder09.getPlaceholder());
         assertEquals("amtsgericht", foundPlaceholder09.getName());
         assertEquals(2, foundPlaceholder09.getPosition());
         assertEquals("", foundPlaceholder09.getReplacedText());

         assertEquals(321, foundPlaceholder10.getIndex());
         assertEquals("<<uebertragend:2>>", foundPlaceholder10.getPlaceholder());
         assertEquals("uebertragend", foundPlaceholder10.getName());
         assertEquals(2, foundPlaceholder10.getPosition());
         assertEquals("", foundPlaceholder10.getReplacedText());

         assertEquals(382, foundPlaceholder11.getIndex());
         assertEquals("<<date:3>>", foundPlaceholder11.getPlaceholder());
         assertEquals("date", foundPlaceholder11.getName());
         assertEquals(3, foundPlaceholder11.getPosition());
         assertEquals("", foundPlaceholder11.getReplacedText());

         assertEquals(431, foundPlaceholder12.getIndex());
         assertEquals("<<company-name:3>>", foundPlaceholder12.getPlaceholder());
         assertEquals("company-name", foundPlaceholder12.getName());
         assertEquals(3, foundPlaceholder12.getPosition());
         assertEquals("", foundPlaceholder12.getReplacedText());

         assertEquals(462, foundPlaceholder13.getIndex());
         assertEquals("<<town:3>>", foundPlaceholder13.getPlaceholder());
         assertEquals("town", foundPlaceholder13.getName());
         assertEquals(3, foundPlaceholder13.getPosition());
         assertEquals("", foundPlaceholder13.getReplacedText());

         assertEquals(473, foundPlaceholder14.getIndex());
         assertEquals("<<amtsgericht:3>>", foundPlaceholder14.getPlaceholder());
         assertEquals("amtsgericht", foundPlaceholder14.getName());
         assertEquals(3, foundPlaceholder14.getPosition());
         assertEquals("", foundPlaceholder14.getReplacedText());

         assertEquals(491, foundPlaceholder15.getIndex());
         assertEquals("<<uebertragend:3>>", foundPlaceholder15.getPlaceholder());
         assertEquals("uebertragend", foundPlaceholder15.getName());
         assertEquals(3, foundPlaceholder15.getPosition());
         assertEquals("", foundPlaceholder15.getReplacedText());

         Map<String, List<FoundPlaceholder>> map = analyser.getPlaceHoldersByName();
         assertEquals(5, map.size());
         assertTrue(map.containsKey("date"));
         assertTrue(map.containsKey("company-name"));
         assertTrue(map.containsKey("town"));
         assertTrue(map.containsKey("amtsgericht"));
         assertTrue(map.containsKey("uebertragend"));

         List<FoundPlaceholder> datePlaceholders = map.get("date");
         List<FoundPlaceholder> companyNamePlaceholders = map.get("company-name");
         List<FoundPlaceholder> townPlaceholders = map.get("town");
         List<FoundPlaceholder> amtsgerichtPlaceholders = map.get("amtsgericht");
         List<FoundPlaceholder> uebertragendPlaceholders = map.get("uebertragend");
         assertEquals(3, datePlaceholders.size());
         assertEquals(3, companyNamePlaceholders.size());
         assertEquals(3, townPlaceholders.size());
         assertEquals(3, amtsgerichtPlaceholders.size());
         assertEquals(3, uebertragendPlaceholders.size());

         FoundPlaceholder datePlaceholder01 = datePlaceholders.get(0);
         FoundPlaceholder datePlaceholder02 = datePlaceholders.get(1);
         FoundPlaceholder datePlaceholder03 = datePlaceholders.get(2);

         FoundPlaceholder companyNamePlaceholder01 = companyNamePlaceholders.get(0);
         FoundPlaceholder companyNamePlaceholder02 = companyNamePlaceholders.get(1);
         FoundPlaceholder companyNamePlaceholder03 = companyNamePlaceholders.get(2);

         FoundPlaceholder townPlaceholder01 = townPlaceholders.get(0);
         FoundPlaceholder townPlaceholder02 = townPlaceholders.get(1);
         FoundPlaceholder townPlaceholder03 = townPlaceholders.get(2);

         FoundPlaceholder amtsgerichtPlaceholder01 = amtsgerichtPlaceholders.get(0);
         FoundPlaceholder amtsgerichtPlaceholder02 = amtsgerichtPlaceholders.get(1);
         FoundPlaceholder amtsgerichtPlaceholder03 = amtsgerichtPlaceholders.get(2);

         FoundPlaceholder uebertragendPlaceholder01 = uebertragendPlaceholders.get(0);
         FoundPlaceholder uebertragendPlaceholder02 = uebertragendPlaceholders.get(1);
         FoundPlaceholder uebertragendPlaceholder03 = uebertragendPlaceholders.get(2);

         assertEquals( 42, datePlaceholder01.getIndex());
         assertEquals("<<date:1>>", datePlaceholder01.getPlaceholder());
         assertEquals("date", datePlaceholder01.getName());
         assertEquals(1, datePlaceholder01.getPosition());
         assertEquals("", datePlaceholder01.getReplacedText());

         assertEquals(212, datePlaceholder02.getIndex());
         assertEquals("<<date:2>>", datePlaceholder02.getPlaceholder());
         assertEquals("date", datePlaceholder02.getName());
         assertEquals(2, datePlaceholder02.getPosition());
         assertEquals("", datePlaceholder02.getReplacedText());

         assertEquals(382, datePlaceholder03.getIndex());
         assertEquals("<<date:3>>", datePlaceholder03.getPlaceholder());
         assertEquals("date", datePlaceholder03.getName());
         assertEquals(3, datePlaceholder03.getPosition());
         assertEquals("", datePlaceholder03.getReplacedText());


         assertEquals( 91, companyNamePlaceholder01.getIndex());
         assertEquals("<<company-name:1>>", companyNamePlaceholder01.getPlaceholder());
         assertEquals("company-name", companyNamePlaceholder01.getName());
         assertEquals(1, companyNamePlaceholder01.getPosition());
         assertEquals("", companyNamePlaceholder01.getReplacedText());

         assertEquals(261, companyNamePlaceholder02.getIndex());
         assertEquals("<<company-name:2>>", companyNamePlaceholder02.getPlaceholder());
         assertEquals("company-name", companyNamePlaceholder02.getName());
         assertEquals(2, companyNamePlaceholder02.getPosition());
         assertEquals("", companyNamePlaceholder02.getReplacedText());

         assertEquals(431, companyNamePlaceholder03.getIndex());
         assertEquals("<<company-name:3>>", companyNamePlaceholder03.getPlaceholder());
         assertEquals("company-name", companyNamePlaceholder03.getName());
         assertEquals(3, companyNamePlaceholder03.getPosition());
         assertEquals("", companyNamePlaceholder03.getReplacedText());


         assertEquals(122, townPlaceholder01.getIndex());
         assertEquals("<<town:1>>", townPlaceholder01.getPlaceholder());
         assertEquals("town", townPlaceholder01.getName());
         assertEquals(1, townPlaceholder01.getPosition());
         assertEquals("", townPlaceholder01.getReplacedText());

         assertEquals(292, townPlaceholder02.getIndex());
         assertEquals("<<town:2>>", townPlaceholder02.getPlaceholder());
         assertEquals("town", townPlaceholder02.getName());
         assertEquals(2, townPlaceholder02.getPosition());
         assertEquals("", townPlaceholder02.getReplacedText());

         assertEquals(462, townPlaceholder03.getIndex());
         assertEquals("<<town:3>>", townPlaceholder03.getPlaceholder());
         assertEquals("town", townPlaceholder03.getName());
         assertEquals(3, townPlaceholder03.getPosition());
         assertEquals("", townPlaceholder03.getReplacedText());


         assertEquals(133, amtsgerichtPlaceholder01.getIndex());
         assertEquals("<<amtsgericht:1>>", amtsgerichtPlaceholder01.getPlaceholder());
         assertEquals("amtsgericht", amtsgerichtPlaceholder01.getName());
         assertEquals(1, amtsgerichtPlaceholder01.getPosition());
         assertEquals("", amtsgerichtPlaceholder01.getReplacedText());

         assertEquals(303, amtsgerichtPlaceholder02.getIndex());
         assertEquals("<<amtsgericht:2>>", amtsgerichtPlaceholder02.getPlaceholder());
         assertEquals("amtsgericht", amtsgerichtPlaceholder02.getName());
         assertEquals(2, amtsgerichtPlaceholder02.getPosition());
         assertEquals("", amtsgerichtPlaceholder02.getReplacedText());

         assertEquals(473, amtsgerichtPlaceholder03.getIndex());
         assertEquals("<<amtsgericht:3>>", amtsgerichtPlaceholder03.getPlaceholder());
         assertEquals("amtsgericht", amtsgerichtPlaceholder03.getName());
         assertEquals(3, amtsgerichtPlaceholder03.getPosition());
         assertEquals("", amtsgerichtPlaceholder03.getReplacedText());


         assertEquals(151, uebertragendPlaceholder01.getIndex());
         assertEquals("<<uebertragend:1>>", uebertragendPlaceholder01.getPlaceholder());
         assertEquals("uebertragend", uebertragendPlaceholder01.getName());
         assertEquals(1, uebertragendPlaceholder01.getPosition());
         assertEquals("", uebertragendPlaceholder01.getReplacedText());

         assertEquals(321, uebertragendPlaceholder02.getIndex());
         assertEquals("<<uebertragend:2>>", uebertragendPlaceholder02.getPlaceholder());
         assertEquals("uebertragend", uebertragendPlaceholder02.getName());
         assertEquals(2, uebertragendPlaceholder02.getPosition());
         assertEquals("", uebertragendPlaceholder02.getReplacedText());

         assertEquals(491, uebertragendPlaceholder03.getIndex());
         assertEquals("<<uebertragend:3>>", uebertragendPlaceholder03.getPlaceholder());
         assertEquals("uebertragend", uebertragendPlaceholder03.getName());
         assertEquals(3, uebertragendPlaceholder03.getPosition());
         assertEquals("", uebertragendPlaceholder03.getReplacedText());
     }

     @Test
     public void test002() {
         String text = ""
                 + "Auf Grund des Verschmelzungsvertrages vom <<date:1>> und der "
                 + "Zustimmungsbeschlüsse ist die <<company-name:1>> mit Sitz in <<town:1>> "
                 + "<<amtsgericht:1>> <<uebertragend:1>> "
                 + ""
                 + "Auf Grund des Verschmelzungsvertrages vom <<date:2>> und der "
                 + "Zustimmungsbeschlüsse ist die <<company-name:2>> mit Sitz in <<town:2>> "
                 + "<<amtsgericht:2>> <<uebertragend:2>> "
                 + ""
                 + "Auf Grund des Verschmelzungsvertrages vom <<date:3>> und der "
                 + "Zustimmungsbeschlüsse ist die <<company-name:3>> mit Sitz in <<town:3>> "
                 + "<<amtsgericht:3>> <<uebertragend:3>>";
         ReplacementsAnalyser analyser = new ReplacementsAnalyser(text);
         analyser.analyse();
         List<String> dates = CollectionsHelper.buildListFrom(
                 "29.04.2022",
                 "29.04.2022",
                 "29.04.2022");
         List<String> companyNames = CollectionsHelper.buildListFrom(
                 "Stuttgarter Straße 60,61/Innstraße 35 Grundstücks GmbH",
                 "EiWo Geschäftsführungs GmbH",
                 "Graefestraße 9 GmbH");
         List<String> towns = CollectionsHelper.buildListFrom(
                 "Zossen",
                 "Zossen",
                 "Zossen");
         List<String> amtsgerichte = CollectionsHelper.buildListFrom(
                 "(Amtsgericht Potsdam, HRB 34755 P)",
                 "(Amtsgericht Potsdam, HRB 29926 P)",
                 "(Amtsgericht Potsdam, HRB 29658 P)");
         List<String> uebertragend = CollectionsHelper.buildListFrom(
                 "durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als Ganzes "
                         + "auf die Gesellschaft verschmolzen.",
                 "durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als Ganzes "
                         + "auf die Gesellschaft verschmolzen.",
                 "durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als Ganzes "
                         + "auf die Gesellschaft verschmolzen.");
         analyser.addReplacedTexts("date", dates);
         analyser.addReplacedTexts("company-name", companyNames);
         analyser.addReplacedTexts("town", towns);
         analyser.addReplacedTexts("amtsgericht", amtsgerichte);
         analyser.addReplacedTexts("uebertragend", uebertragend);

         List<FoundPlaceholder> foundPlaceholders = analyser.getFoundPlaceholders();
         assertEquals(15, foundPlaceholders.size());
         FoundPlaceholder foundPlaceholder01 = foundPlaceholders.get( 0);
         FoundPlaceholder foundPlaceholder02 = foundPlaceholders.get( 1);
         FoundPlaceholder foundPlaceholder03 = foundPlaceholders.get( 2);
         FoundPlaceholder foundPlaceholder04 = foundPlaceholders.get( 3);
         FoundPlaceholder foundPlaceholder05 = foundPlaceholders.get( 4);
         FoundPlaceholder foundPlaceholder06 = foundPlaceholders.get( 5);
         FoundPlaceholder foundPlaceholder07 = foundPlaceholders.get( 6);
         FoundPlaceholder foundPlaceholder08 = foundPlaceholders.get( 7);
         FoundPlaceholder foundPlaceholder09 = foundPlaceholders.get( 8);
         FoundPlaceholder foundPlaceholder10 = foundPlaceholders.get( 9);
         FoundPlaceholder foundPlaceholder11 = foundPlaceholders.get(10);
         FoundPlaceholder foundPlaceholder12 = foundPlaceholders.get(11);
         FoundPlaceholder foundPlaceholder13 = foundPlaceholders.get(12);
         FoundPlaceholder foundPlaceholder14 = foundPlaceholders.get(13);
         FoundPlaceholder foundPlaceholder15 = foundPlaceholders.get(14);

         assertEquals( 42, foundPlaceholder01.getIndex());
         assertEquals("<<date:1>>", foundPlaceholder01.getPlaceholder());
         assertEquals("date", foundPlaceholder01.getName());
         assertEquals(1, foundPlaceholder01.getPosition());
         assertEquals("29.04.2022", foundPlaceholder01.getReplacedText());

         assertEquals( 91, foundPlaceholder02.getIndex());
         assertEquals("<<company-name:1>>", foundPlaceholder02.getPlaceholder());
         assertEquals("company-name", foundPlaceholder02.getName());
         assertEquals(1, foundPlaceholder02.getPosition());
         assertEquals("Stuttgarter Straße 60,61/Innstraße 35 Grundstücks GmbH",
                 foundPlaceholder02.getReplacedText());

         assertEquals(122, foundPlaceholder03.getIndex());
         assertEquals("<<town:1>>", foundPlaceholder03.getPlaceholder());
         assertEquals("town", foundPlaceholder03.getName());
         assertEquals(1, foundPlaceholder03.getPosition());
         assertEquals("Zossen", foundPlaceholder03.getReplacedText());

         assertEquals(133, foundPlaceholder04.getIndex());
         assertEquals("<<amtsgericht:1>>", foundPlaceholder04.getPlaceholder());
         assertEquals("amtsgericht", foundPlaceholder04.getName());
         assertEquals(1, foundPlaceholder04.getPosition());
         assertEquals("(Amtsgericht Potsdam, HRB 34755 P)", foundPlaceholder04.getReplacedText());

         assertEquals(151, foundPlaceholder05.getIndex());
         assertEquals("<<uebertragend:1>>", foundPlaceholder05.getPlaceholder());
         assertEquals("uebertragend", foundPlaceholder05.getName());
         assertEquals(1, foundPlaceholder05.getPosition());
         assertEquals("durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als "
                 + "Ganzes auf die Gesellschaft verschmolzen.",
                 foundPlaceholder05.getReplacedText());

         assertEquals(212, foundPlaceholder06.getIndex());
         assertEquals("<<date:2>>", foundPlaceholder06.getPlaceholder());
         assertEquals("date", foundPlaceholder06.getName());
         assertEquals(2, foundPlaceholder06.getPosition());
         assertEquals("29.04.2022", foundPlaceholder06.getReplacedText());

         assertEquals(261, foundPlaceholder07.getIndex());
         assertEquals("<<company-name:2>>", foundPlaceholder07.getPlaceholder());
         assertEquals("company-name", foundPlaceholder07.getName());
         assertEquals(2, foundPlaceholder07.getPosition());
         assertEquals("EiWo Geschäftsführungs GmbH", foundPlaceholder07.getReplacedText());

         assertEquals(292, foundPlaceholder08.getIndex());
         assertEquals("<<town:2>>", foundPlaceholder08.getPlaceholder());
         assertEquals("town", foundPlaceholder08.getName());
         assertEquals(2, foundPlaceholder08.getPosition());
         assertEquals("Zossen", foundPlaceholder08.getReplacedText());

         assertEquals(303, foundPlaceholder09.getIndex());
         assertEquals("<<amtsgericht:2>>", foundPlaceholder09.getPlaceholder());
         assertEquals("amtsgericht", foundPlaceholder09.getName());
         assertEquals(2, foundPlaceholder09.getPosition());
         assertEquals("(Amtsgericht Potsdam, HRB 29926 P)", foundPlaceholder09.getReplacedText());

         assertEquals(321, foundPlaceholder10.getIndex());
         assertEquals("<<uebertragend:2>>", foundPlaceholder10.getPlaceholder());
         assertEquals("uebertragend", foundPlaceholder10.getName());
         assertEquals(2, foundPlaceholder10.getPosition());
         assertEquals("durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als "
                 + "Ganzes auf die Gesellschaft verschmolzen.",
                 foundPlaceholder10.getReplacedText());

         assertEquals(382, foundPlaceholder11.getIndex());
         assertEquals("<<date:3>>", foundPlaceholder11.getPlaceholder());
         assertEquals("date", foundPlaceholder11.getName());
         assertEquals(3, foundPlaceholder11.getPosition());
         assertEquals("29.04.2022", foundPlaceholder11.getReplacedText());

         assertEquals(431, foundPlaceholder12.getIndex());
         assertEquals("<<company-name:3>>", foundPlaceholder12.getPlaceholder());
         assertEquals("company-name", foundPlaceholder12.getName());
         assertEquals(3, foundPlaceholder12.getPosition());
         assertEquals("Graefestraße 9 GmbH", foundPlaceholder12.getReplacedText());

         assertEquals(462, foundPlaceholder13.getIndex());
         assertEquals("<<town:3>>", foundPlaceholder13.getPlaceholder());
         assertEquals("town", foundPlaceholder13.getName());
         assertEquals(3, foundPlaceholder13.getPosition());
         assertEquals("Zossen", foundPlaceholder13.getReplacedText());

         assertEquals(473, foundPlaceholder14.getIndex());
         assertEquals("<<amtsgericht:3>>", foundPlaceholder14.getPlaceholder());
         assertEquals("amtsgericht", foundPlaceholder14.getName());
         assertEquals(3, foundPlaceholder14.getPosition());
         assertEquals("(Amtsgericht Potsdam, HRB 29658 P)", foundPlaceholder14.getReplacedText());

         assertEquals(491, foundPlaceholder15.getIndex());
         assertEquals("<<uebertragend:3>>", foundPlaceholder15.getPlaceholder());
         assertEquals("uebertragend", foundPlaceholder15.getName());
         assertEquals(3, foundPlaceholder15.getPosition());
         assertEquals("durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als "
                 + "Ganzes auf die Gesellschaft verschmolzen.",
                 foundPlaceholder15.getReplacedText());

         Map<String, List<FoundPlaceholder>> map = analyser.getPlaceHoldersByName();
         assertEquals(5, map.size());
         assertTrue(map.containsKey("date"));
         assertTrue(map.containsKey("company-name"));
         assertTrue(map.containsKey("town"));
         assertTrue(map.containsKey("amtsgericht"));
         assertTrue(map.containsKey("uebertragend"));

         List<FoundPlaceholder> datePlaceholders = map.get("date");
         List<FoundPlaceholder> companyNamePlaceholders = map.get("company-name");
         List<FoundPlaceholder> townPlaceholders = map.get("town");
         List<FoundPlaceholder> amtsgerichtPlaceholders = map.get("amtsgericht");
         List<FoundPlaceholder> uebertragendPlaceholders = map.get("uebertragend");
         assertEquals(3, datePlaceholders.size());
         assertEquals(3, companyNamePlaceholders.size());
         assertEquals(3, townPlaceholders.size());
         assertEquals(3, amtsgerichtPlaceholders.size());
         assertEquals(3, uebertragendPlaceholders.size());

         FoundPlaceholder datePlaceholder01 = datePlaceholders.get(0);
         FoundPlaceholder datePlaceholder02 = datePlaceholders.get(1);
         FoundPlaceholder datePlaceholder03 = datePlaceholders.get(2);

         FoundPlaceholder companyNamePlaceholder01 = companyNamePlaceholders.get(0);
         FoundPlaceholder companyNamePlaceholder02 = companyNamePlaceholders.get(1);
         FoundPlaceholder companyNamePlaceholder03 = companyNamePlaceholders.get(2);

         FoundPlaceholder townPlaceholder01 = townPlaceholders.get(0);
         FoundPlaceholder townPlaceholder02 = townPlaceholders.get(1);
         FoundPlaceholder townPlaceholder03 = townPlaceholders.get(2);

         FoundPlaceholder amtsgerichtPlaceholder01 = amtsgerichtPlaceholders.get(0);
         FoundPlaceholder amtsgerichtPlaceholder02 = amtsgerichtPlaceholders.get(1);
         FoundPlaceholder amtsgerichtPlaceholder03 = amtsgerichtPlaceholders.get(2);

         FoundPlaceholder uebertragendPlaceholder01 = uebertragendPlaceholders.get(0);
         FoundPlaceholder uebertragendPlaceholder02 = uebertragendPlaceholders.get(1);
         FoundPlaceholder uebertragendPlaceholder03 = uebertragendPlaceholders.get(2);

         assertEquals( 42, datePlaceholder01.getIndex());
         assertEquals("<<date:1>>", datePlaceholder01.getPlaceholder());
         assertEquals("date", datePlaceholder01.getName());
         assertEquals(1, datePlaceholder01.getPosition());
         assertEquals("29.04.2022", datePlaceholder01.getReplacedText());

         assertEquals(212, datePlaceholder02.getIndex());
         assertEquals("<<date:2>>", datePlaceholder02.getPlaceholder());
         assertEquals("date", datePlaceholder02.getName());
         assertEquals(2, datePlaceholder02.getPosition());
         assertEquals("29.04.2022", datePlaceholder02.getReplacedText());

         assertEquals(382, datePlaceholder03.getIndex());
         assertEquals("<<date:3>>", datePlaceholder03.getPlaceholder());
         assertEquals("date", datePlaceholder03.getName());
         assertEquals(3, datePlaceholder03.getPosition());
         assertEquals("29.04.2022", datePlaceholder03.getReplacedText());


         assertEquals( 91, companyNamePlaceholder01.getIndex());
         assertEquals("<<company-name:1>>", companyNamePlaceholder01.getPlaceholder());
         assertEquals("company-name", companyNamePlaceholder01.getName());
         assertEquals(1, companyNamePlaceholder01.getPosition());
         assertEquals("Stuttgarter Straße 60,61/Innstraße 35 Grundstücks GmbH",
                 companyNamePlaceholder01.getReplacedText());

         assertEquals(261, companyNamePlaceholder02.getIndex());
         assertEquals("<<company-name:2>>", companyNamePlaceholder02.getPlaceholder());
         assertEquals("company-name", companyNamePlaceholder02.getName());
         assertEquals(2, companyNamePlaceholder02.getPosition());
         assertEquals("EiWo Geschäftsführungs GmbH", companyNamePlaceholder02.getReplacedText());

         assertEquals(431, companyNamePlaceholder03.getIndex());
         assertEquals("<<company-name:3>>", companyNamePlaceholder03.getPlaceholder());
         assertEquals("company-name", companyNamePlaceholder03.getName());
         assertEquals(3, companyNamePlaceholder03.getPosition());
         assertEquals("Graefestraße 9 GmbH", companyNamePlaceholder03.getReplacedText());


         assertEquals(122, townPlaceholder01.getIndex());
         assertEquals("<<town:1>>", townPlaceholder01.getPlaceholder());
         assertEquals("town", townPlaceholder01.getName());
         assertEquals(1, townPlaceholder01.getPosition());
         assertEquals("Zossen", townPlaceholder01.getReplacedText());

         assertEquals(292, townPlaceholder02.getIndex());
         assertEquals("<<town:2>>", townPlaceholder02.getPlaceholder());
         assertEquals("town", townPlaceholder02.getName());
         assertEquals(2, townPlaceholder02.getPosition());
         assertEquals("Zossen", townPlaceholder02.getReplacedText());

         assertEquals(462, townPlaceholder03.getIndex());
         assertEquals("<<town:3>>", townPlaceholder03.getPlaceholder());
         assertEquals("town", townPlaceholder03.getName());
         assertEquals(3, townPlaceholder03.getPosition());
         assertEquals("Zossen", townPlaceholder03.getReplacedText());


         assertEquals(133, amtsgerichtPlaceholder01.getIndex());
         assertEquals("<<amtsgericht:1>>", amtsgerichtPlaceholder01.getPlaceholder());
         assertEquals("amtsgericht", amtsgerichtPlaceholder01.getName());
         assertEquals(1, amtsgerichtPlaceholder01.getPosition());
         assertEquals("(Amtsgericht Potsdam, HRB 34755 P)",
                 amtsgerichtPlaceholder01.getReplacedText());

         assertEquals(303, amtsgerichtPlaceholder02.getIndex());
         assertEquals("<<amtsgericht:2>>", amtsgerichtPlaceholder02.getPlaceholder());
         assertEquals("amtsgericht", amtsgerichtPlaceholder02.getName());
         assertEquals(2, amtsgerichtPlaceholder02.getPosition());
         assertEquals("(Amtsgericht Potsdam, HRB 29926 P)",
                 amtsgerichtPlaceholder02.getReplacedText());

         assertEquals(473, amtsgerichtPlaceholder03.getIndex());
         assertEquals("<<amtsgericht:3>>", amtsgerichtPlaceholder03.getPlaceholder());
         assertEquals("amtsgericht", amtsgerichtPlaceholder03.getName());
         assertEquals(3, amtsgerichtPlaceholder03.getPosition());
         assertEquals("(Amtsgericht Potsdam, HRB 29658 P)",
                 amtsgerichtPlaceholder03.getReplacedText());


         assertEquals(151, uebertragendPlaceholder01.getIndex());
         assertEquals("<<uebertragend:1>>", uebertragendPlaceholder01.getPlaceholder());
         assertEquals("uebertragend", uebertragendPlaceholder01.getName());
         assertEquals(1, uebertragendPlaceholder01.getPosition());
         assertEquals("durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als "
                 + "Ganzes auf die Gesellschaft verschmolzen.",
                 uebertragendPlaceholder01.getReplacedText());

         assertEquals(321, uebertragendPlaceholder02.getIndex());
         assertEquals("<<uebertragend:2>>", uebertragendPlaceholder02.getPlaceholder());
         assertEquals("uebertragend", uebertragendPlaceholder02.getName());
         assertEquals(2, uebertragendPlaceholder02.getPosition());
         assertEquals("durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als "
                 + "Ganzes auf die Gesellschaft verschmolzen.",
                 uebertragendPlaceholder02.getReplacedText());

         assertEquals(491, uebertragendPlaceholder03.getIndex());
         assertEquals("<<uebertragend:3>>", uebertragendPlaceholder03.getPlaceholder());
         assertEquals("uebertragend", uebertragendPlaceholder03.getName());
         assertEquals(3, uebertragendPlaceholder03.getPosition());
         assertEquals("durch Übertragung ihres Vermögens unter Auflösung ohne Abwicklung als "
                 + "Ganzes auf die Gesellschaft verschmolzen.",
                 uebertragendPlaceholder03.getReplacedText());
     }

}
