package de.duehl.basics.text.xml.own;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.text.Text;

public class OwnXmlHelperTest {

    @Test
    public void singleUniqueXmlElementToXmlString() {
        String tag = "tag";
        String content = "content";
        String actual = OwnXmlHelper.singleUniqueXmlElementToXmlString(tag, content);
        String expected = "<tag>content</tag>";
        assertEquals(expected, actual);
    }

    @Test
    public void readContentOfSingleUniqueXmlElementInXmlLine() {
        String tag = "tag";
        String line = "<outer><tag>content</tag></outer>";
        String actual = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlLine(tag, line);
        String expected = "content";
        assertEquals(expected, actual);
    }

    @Test
    public void readContentOfSingleUniqueXmlElementInXmlLineWithOutOuter() {
        String tag = "tag";
        String line = "<tag>content</tag>";
        String actual = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlLine(tag, line);
        String expected = "content";
        assertEquals(expected, actual);
    }

    @Test
    public void readContentOfSingleUniqueXmlElementInXmlMultipleLineSimple() {
        String tag = "collection";
        String n = Text.LINE_BREAK;
        String line = ""
                + "<collection>" + n
                + "    <inner>" + n
                + "        data_1" + n
                + "    </inner>" + n
                + "    <inner>" + n
                + "        data_2" + n
                + "    </inner>" + n
                + "    <inner>" + n
                + "        data_3" + n
                + "    </inner>" + n
                + "</collection>"
                ;
        String actual = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlMultipleLine(tag, line);
        String expected = line;
        assertEquals(expected, actual);
    }

    @Test
    public void readContentOfSingleUniqueXmlElementInXmlMultipleLine() {
        String tag = "collection";
        String n = Text.LINE_BREAK;
        String line = ""
                + "<data>" + n
                + "    <collection>" + n
                + "        <inner>" + n
                + "            data_1" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_2" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_3" + n
                + "        </inner>" + n
                + "    </collection>" + n
                + "<data>"
                ;
        String actual = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlMultipleLine(tag, line);
        String expected = ""
                + "    <collection>" + n
                + "        <inner>" + n
                + "            data_1" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_2" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_3" + n
                + "        </inner>" + n
                + "    </collection>"
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void readContentOfSingleUniqueXmlElementInXmlMultipleLineComplex() {
        String tag = "collection";
        String n = Text.LINE_BREAK;
        String line = ""
                + "<data>" + n
                + "    <foo>" + n
                + "        FOO" + n
                + "    </foo>" + n
                + "    <collection>" + n
                + "        <inner>" + n
                + "            data_1" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_2" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_3" + n
                + "        </inner>" + n
                + "    </collection>" + n
                + "    <bar>" + n
                + "        BAR" + n
                + "    </bar>" + n
                + "<data>"
                ;
        String actual = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlMultipleLine(tag, line);
        String expected = ""
                + "    <collection>" + n
                + "        <inner>" + n
                + "            data_1" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_2" + n
                + "        </inner>" + n
                + "        <inner>" + n
                + "            data_3" + n
                + "        </inner>" + n
                + "    </collection>"
                ;
        assertEquals(expected, actual);
    }

}
