package de.duehl.math.stochastic;

/**
 * Diese Klasse stellt eine Stichprobe mit Zurücklegen her.
 *
 * @version 1.01     2019-04-08
 * @author Christian Dühl
 */

public class RandomSampleWithoutPutBack extends RandomSample {

    /**
     * Konstruktor. Die erste natürliche positive Zahl im Set, von dem die Stichprobe gezogen
     * werden soll, wird hier auf 1 gesetzt.
     *
     * @param to
     *            Letzte (einschließlich) natürliche positive Zahl im Set, von dem die Stichprobe
     *            gezogen werden soll.
     * @param sampleSize
     *            Größe der zu ziehenden Stichprobe.
     */
    public RandomSampleWithoutPutBack(int to, int sampleSize) {
        this(1, to, sampleSize);
    }

    /**
     * Konstruktor.
     *
     * @param from
     *            Erste natürliche positive Zahl im Set, von dem die Stichprobe gezogen werden
     *            soll.
     * @param to
     *            Letzte (einschließlich) natürliche positive Zahl im Set, von dem die Stichprobe
     *            gezogen werden soll.
     * @param sampleSize
     *            Größe der zu ziehenden Stichprobe.
     */
    public RandomSampleWithoutPutBack(int from, int to, int sampleSize) {
        super(from, to, sampleSize);

        if (this.sampleSize > setSize) {
            throw new IllegalArgumentException("Die Menge hat nicht genug Elemente, um die "
                    + "Stichprobe ohne Zurücklgen zu befüllen.");
        }
    }

    /** Gibt an, ob die Nummer zulässig ist, wenn man sie zur Stichprobe hinzufügt. */
    @Override
    protected boolean isNumberValidToAddToSample(int number) {
        return !sampleContains(number); // ohne Zurücklegen ist nur jede nicht im Sample
                                        // befindliche Nummer valide
    }

}
