package de.duehl.mp3.player;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class VolumeCalculationsTest {

    @Test
    public void minDbToPercent() {
        float volumeDb = VolumeCalculations.MIN_VOLUME_DB;
        int actual = VolumeCalculations.volumeDbToVolumePercent(volumeDb);
        int expected = VolumeCalculations.MIN_VOLUME_PERCENT;
        assertEquals(expected, actual);
    }

    @Test
    public void maxDbToPercent() {
        float volumeDb = VolumeCalculations.MAX_VOLUME_DB;
        int actual = VolumeCalculations.volumeDbToVolumePercent(volumeDb);
        int expected = VolumeCalculations.MAX_VOLUME_PERCENT;
        assertEquals(expected, actual);
    }

    @Test
    public void minPercentToDb() {
        int volumePercent = VolumeCalculations.MIN_VOLUME_PERCENT;
        float actual = VolumeCalculations.volumePercentToVolumeDb(volumePercent);
        float expected = VolumeCalculations.MIN_VOLUME_DB;
        assertEquals(expected, actual, 0.01f);
    }

    @Test
    public void maxPercentToDb() {
        int volumePercent = VolumeCalculations.MAX_VOLUME_PERCENT;
        float actual = VolumeCalculations.volumePercentToVolumeDb(volumePercent);
        float expected = VolumeCalculations.MAX_VOLUME_DB;
        assertEquals(expected, actual, 0.01f);
    }

    @Test
    public void toCorrectVolumePercentToLow() {
        int volumePercent = -13;
        int actual = VolumeCalculations.toCorrectVolumePercent(volumePercent);
        int expected = VolumeCalculations.MIN_VOLUME_PERCENT;
        assertEquals(expected, actual);
    }

    @Test
    public void toCorrectVolumePercentOk() {
        int volumePercent = 77;
        int actual = VolumeCalculations.toCorrectVolumePercent(volumePercent);
        int expected = volumePercent;
        assertEquals(expected, actual);
    }

    @Test
    public void toCorrectVolumePercentTooHigh() {
        int volumePercent = 155;
        int actual = VolumeCalculations.toCorrectVolumePercent(volumePercent);
        int expected = VolumeCalculations.MAX_VOLUME_PERCENT;
        assertEquals(expected, actual);
    }

    @Test
    public void toCorrectVolumeDbToLow() {
        float volumeDb = -200f;
        float actual = VolumeCalculations.toCorrectVolumeDb(volumeDb);
        float expected = VolumeCalculations.MIN_VOLUME_DB;
        assertEquals(expected, actual, 0.01f);
    }

    @Test
    public void toCorrectVolumeDbOk() {
        float volumeDb = -20f;
        float actual = VolumeCalculations.toCorrectVolumeDb(volumeDb);
        float expected = volumeDb;
        assertEquals(expected, actual, 0.01f);
    }

    @Test
    public void toCorrectVolumeDbTooHigh() {
        float volumeDb = 200f;
        float actual = VolumeCalculations.toCorrectVolumeDb(volumeDb);
        float expected = VolumeCalculations.MAX_VOLUME_DB;
        assertEquals(expected, actual, 0.01f);
    }

}
