package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;

import de.duehl.swing.ui.colors.Colorizer;

/**
 * Diese Klasse stellt die Auswahl einer Option in einem Optionendialog dar.
 *
 * @version 1.01     2017-02-27
 * @author Christian Dühl
 */

public class OptionSelection {

    /** CheckBox für die Option. */
    private final JCheckBox titleBox;

    /**
     * Konstruktor.
     *
     * @param title
     *            Überschrift für die Wahl dieser Datei oder dieses Verzeichnisses.
     */
    public OptionSelection(String title) {
        titleBox = new JCheckBox(title);
    }

    /** Fragt ab, ob die Option ausgewählt ist. */
    public boolean isSelected() {
        return titleBox.isSelected();
    }

    /** Setzt die Option auf ausgewählt oder nicht ausgewählt. */
    public void setSelected(boolean selected) {
        titleBox.setSelected(selected);
    }

    /** Getter für das Panel mit Überschrift, Pfad und Änderungsbutton. */
    public Component getCheckBox() {
        return titleBox;
    }

    /** Färbt alle Komponenten mit dem übergebenen Colorizer ein. */
    public void colorize(Colorizer colorizer) {
        colorizer.setColors(titleBox);
    }

    /** Setter für die gewünschte Größe der CheckBox. */
    public void setPreferredSize(Dimension preferredSize) {
        titleBox.setPreferredSize(preferredSize);
    }

    /** Fügt einen ChangeListener zur CheckBox hinzu. */
    public void addChangeListener(ChangeListener changeListener) {
        titleBox.addChangeListener(changeListener);
    }

}
