package de.duehl.swing.ui.highlightingeditor.syntax.data;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

public class TokenWithStyleAndPosition extends TokenWithPosition {

    private final String style;

    public TokenWithStyleAndPosition(TokenWithPosition tokenWithPosition, String style) {
        this(tokenWithPosition.getText(), style, tokenWithPosition.getTextPosition());
    }

    public TokenWithStyleAndPosition(String text, String style, int textPosition) {
        super(text, textPosition);
        this.style = style;
    }

    public String getStyle() {
        return style;
    }

    @Override
    public String toString() {
        return "TextWithStyleAndPosition [style=" + style + ", getText()=" + getText()
                + ", getTextPosition()=" + getTextPosition() + "]";
    }

}
