package de.duehl.swing.ui.filter.method;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

public class MethodCombinationTest {

    @Test
    public void negateList() {
        List<Integer> fullList = new ArrayList<>();
        fullList.add(1);
        fullList.add(2);
        fullList.add(3);

        List<Integer> listToNegate = new ArrayList<>();
        listToNegate.add(1);

        List<Integer> negatedList = MethodCombination.negateList(listToNegate, fullList);

        assertEquals(2, negatedList.size());
        assertTrue(2 == negatedList.get(0));
        assertTrue(3 == negatedList.get(1));
    }

    @Test
    public void intersectLists() {
        List<Integer> list1 = new ArrayList<>();
        list1.add(1);
        list1.add(2);
        list1.add(3);

        List<Integer> list2 = new ArrayList<>();
        list2.add(3);
        list2.add(4);
        list2.add(5);

        List<Integer> intersectionList = MethodCombination.intersectLists(list1, list2);

        assertEquals(1, intersectionList.size());
        assertTrue(3 == intersectionList.get(0));
    }

    @Test
    public void uniteLists() {
        List<Integer> list1 = new ArrayList<>();
        list1.add(1);
        list1.add(2);
        list1.add(3);

        List<Integer> list2 = new ArrayList<>();
        list2.add(3);
        list2.add(4);
        list2.add(5);

        List<Integer> unitedList = MethodCombination.uniteLists(list1, list2);

        assertEquals(5, unitedList.size());
        assertTrue(1 == unitedList.get(0));
        assertTrue(2 == unitedList.get(1));
        assertTrue(3 == unitedList.get(2));
        assertTrue(4 == unitedList.get(3));
        assertTrue(5 == unitedList.get(4));
    }

}
