package de.duehl.swing.ui.start;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.text.TextViewer;

public class EditorViewDialogSwingTest {

    private JFrame frame;

    public EditorViewDialogSwingTest() {
        frame = new JFrame();
        frame.setPreferredSize(new Dimension(250, 120));
        frame.setTitle("Testprogramm für die EditorDialog als Viewer.");
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new VerticalLayout(1, VerticalLayout.BOTH));

        {
            JButton openTextFileButton = new JButton(".txt Datei öffnen");
            frame.add(openTextFileButton);
            openTextFileButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent arg0) {
                    openTextFile();
                }
            });
        }
        {
            JButton openTextFileButton = new JButton(".html Datei öffnen");
            frame.add(openTextFileButton);
            openTextFileButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent arg0) {
                    openHTMLFile();
                }
            });
        }
        {
            JButton openTextFileButton = new JButton(".java Datei öffnen");
            frame.add(openTextFileButton);
            openTextFileButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent arg0) {
                    openJavaFile();
                }
            });
        }


        frame.pack();
        frame.setVisible(true);
    }

    private void openTextFile() {
        open(".txt");
    }

    private void openHTMLFile() {
        open(".html");
    }

    private void openJavaFile() {
        open(".java");
    }

    private void open(String extension) {
        openSomeFileInViewer(frame, extension);
    }

    /**
     * Fragt den Benutzer nach einer bestimmten Dateiart, die geöffnet werden soll und zeigt die
     * Datei im Editor an.
     *
     * @param parent
     *            Übergeordnete Gui-Komponente.
     * @param extension
     *            Endung der Datei, wie z.B. ".txt"
     */
    public static void openSomeFileInViewer(Component parent, String extension) {
        String filename = GuiTools.openFileWithExtension(parent, extension);
        if (filename.isEmpty()) {
            return;
        }
        String contents = FileHelper.readFileToString(filename);

        TextViewer viewer = new TextViewer("Datei " + filename, parent.getLocation());
        viewer.setText(contents);
        viewer.scrollScrollbarToMinimumLater();
        viewer.useMonoscpacedText();
        viewer.setVisible(true);
    }

    public static void main(String[] args) {
        new EditorViewDialogSwingTest();
    }

}
