package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

import de.duehl.swing.ui.elements.ScrollablePanel;
import de.duehl.swing.ui.layout.VerticalLayout;

public class ScrollablePanelTest {

    private JFrame frame;
    private JTextField textField;

    public ScrollablePanelTest() {
        createFrame();
        frame.setVisible(true);
    }

    private void createFrame() {
        setNiceLayoutManager();
        frame = new JFrame("Too long text field in slit pane");
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        frame.add(createSplitPane(), BorderLayout.CENTER);
        frame.add(createButtons(), BorderLayout.SOUTH);

        frame.setPreferredSize(new Dimension(900, 650));
        frame.setLocation(100, 75);
        frame.pack();
    }

    public static void setNiceLayoutManager() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Component createSplitPane() {
        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, createDataPart(),
                createDocumentPart());
        splitPane.setDividerLocation(600);
        return splitPane;
    }

    private Component createDataPart() {
        ScrollablePanel panel = new ScrollablePanel();
        panel.setScrollHorizontal(false);

        panel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
        panel.setBorder(BorderFactory.createTitledBorder(""));

        panel.add(createTextFieldPart());
        panel.add(createLabelPart("und"));
        panel.add(createLabelPart("so"));
        panel.add(createLabelPart("manche"));
        panel.add(createLabelPart("andere"));
        panel.add(createLabelPart("Felder"));
        panel.add(createLabelPart("zum"));
        panel.add(createLabelPart("Eingeben"));
        panel.add(createLabelPart("von"));
        panel.add(createLabelPart("weiteren"));
        panel.add(createLabelPart("Daten"));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));
        panel.add(createLabelPart("."));

        return new JScrollPane(panel);
    }

    private Component createTextFieldPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));

        panel.add(new JLabel("Name "), BorderLayout.WEST);

        textField = new JTextField();
        JScrollPane scrollPane = new JScrollPane(textField);
        scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        panel.add(scrollPane, BorderLayout.CENTER);

        return panel;
    }

    private Component createLabelPart(String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));

        panel.add(new JLabel(text), BorderLayout.CENTER);

        return panel;
    }

    private Component createDocumentPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));

        panel.add(new JLabel("irgendwelche anderen Gui-Elemente"), BorderLayout.CENTER);

        return panel;
    }

    private Component createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));

        panel.add(createLongTextButton(), BorderLayout.EAST);
        panel.add(createShortTextButton(), BorderLayout.WEST);

        return panel;
    }

    private Component createLongTextButton() {
        return createButton("long",
                "Ein sehr langer Name der das Layout durch seine exorbitante, unfassbare, schier "
                        + "unglaubliche Länge sprengt und alles völlig unansehnlich macht...");
    }

    private Component createShortTextButton() {
        return createButton("short", "Max Mustermann");
    }

    private JButton createButton(String title, String text) {
        JButton button = new JButton(title);
        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fillText(text);
            }
        });
        return button;
    }

    private void fillText(String text) {
        textField.setText(text);
        frame.revalidate();
    }

    public static void main(String[] args) {
        new ScrollablePanelTest();
    }

}