package de.duehl.swing.ui.start;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JLabel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.creator.ColoredLabelButtonCreator;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.components.elements.VerticalTabulator;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;

/**
 * Diese Klasse testet den VerticalTabulator.
 *
 * @version 1.01     2021-05-07
 * @author Christian Dühl
 */

public class VerticalTabulatorTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(1200, 600);

    VerticalTabulator verticalTabulator;

    /** Konstruktor. */
    public VerticalTabulatorTest() {
        super("VerticalTabulator Test", DIALOG_DIMENSION);
        addEscapeBehaviour();

        verticalTabulator = new VerticalTabulator();

        initVerticalTabulator();

        fillDialog();
    }

    private void initVerticalTabulator() {
        verticalTabulator.setButtonCreator(new ColoredLabelButtonCreator(ColorTool.orange())
                .setMouseEnteredLabelColor(new Color(200, 0, 255))
                .setMousePressedLabelColor(new Color(160, 0, 215)));
        verticalTabulator.createBorders();

        verticalTabulator.addTabulator("eins", createDemoContent("1"));
        verticalTabulator.addTabulator("zwei", createDemoContent("2"));
        verticalTabulator.addTabulator("drei", createDemoContent("3"));
        verticalTabulator.addTabulator("vier", createDemoContent("4"));
        verticalTabulator.addTabulator("fünf", createDemoContent("5"));
        verticalTabulator.addTabulator("--- Hilfe ---", createDemoContent("Zu Hülfe!"));
    }

    public JLabel createDemoContent(String contentText) {
        JLabel label = new JLabel(contentText);
        GuiTools.biggerFont(label, 10);
        label.setHorizontalAlignment(JLabel.CENTER);
        label.setVerticalAlignment(JLabel.CENTER);
        return label;
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        add(verticalTabulator.createPanelWithButtonsOnTheLeft(), BorderLayout.CENTER);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        new VerticalTabulatorTest().setVisible(true);
    }

}
