package de.duehl.swing.ui.start.pages;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.pages.DatasetsOnPages;

public class DatasetsOnPagesTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 1000);

    private final List<String> datasets;
    private final DatasetsOnPages<String> pages;

    public DatasetsOnPagesTest() {
        super("Daten auf Seiten anzeigen - TEST", DIALOG_DIMENSION);

        datasets = new ArrayList<>();
        fillDemoDatasets();

        int numberOfElementsPerSide = 20;
        int numberOfColumns = 3;
        pages = new DatasetsOnPages<>(datasets, new PanelFromStringCreatorForTest(),
                numberOfElementsPerSide, numberOfColumns);

        fillDialog();
    }

    private void fillDemoDatasets() {
        for (int number = 1; number <= 10_000; ++number) {
            String numberString = NumberString.taupu(number);
            datasets.add(numberString);
        }
    }

    @Override
    protected void populateDialog() {
        add(pages.getPanel(), BorderLayout.CENTER);
    }

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        new DatasetsOnPagesTest().setVisible(true);
    }

}
