package de.duehl.swing.ui.start.timedate;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.components.selections.datetime.QuarterlyTimeSelection;

public class QuarterlyTimeSelectionTest {

    private final QuarterlyTimeSelection timeSelection = new QuarterlyTimeSelection();

    public QuarterlyTimeSelectionTest() {
        SwingUtilities.invokeLater(this::createFrame);
    }

    private void createFrame() {
        JFrame frame= new JFrame();
        frame.setTitle("Viertelstunde - Testprogramm zum Wählen einer Uhrzeit.");

        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(createSpinners(), BorderLayout.CENTER);
        frame.add(createPrintWeekdayButton(), BorderLayout.SOUTH);

        frame.pack();
        frame.setVisible(true);
    }

    private Component createSpinners() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());

        panel.add(new JLabel("Bitte die Uhrzeit eingeben:"));
        panel.add(timeSelection.getPanel());

        return panel;
    }

    private Component createPrintWeekdayButton() {
        JButton button = new JButton("Print");
        button.addActionListener(e -> print());
        return button;
    }

    private void print() {
        System.out.println("Gewählt: '" + timeSelection.getTime() + "'");
    }

    public static void main(String[] args) {
        new QuarterlyTimeSelectionTest();
    }

}
