package de.duehl.vocabulary.japanese.common.website.update.vocables.parser;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class VocableVersionParserTest {

    @Test
    void emptyVersionFail() {
        String vocablesVersion = "";
        VocableVersionParser parser = new VocableVersionParser(vocablesVersion);
        parser.parse();
        assertFalse(parser.isSuccess());
        assertEquals("Da die Version '' keinen Unterstrich enthält, wird sie nicht berücksichtigt.",
                parser.getFailReason());

        assertEquals(-1, parser.getNumber());
        assertEquals("", parser.getDateAsString());
    }

    @Test
    void frontLengthFail() {
        String vocablesVersion = "123456789_3";
        VocableVersionParser parser = new VocableVersionParser(vocablesVersion);
        parser.parse();
        assertFalse(parser.isSuccess());
        assertEquals("Da der vordere Teil (123456789) der Version '123456789_3' nicht acht "
                + "Zeichen lang ist, wird sie nicht berücksichtigt.",
                parser.getFailReason());

        assertEquals(-1, parser.getNumber());
        assertEquals("", parser.getDateAsString());
    }

    @Test
    void frontNotOnlyDigitsFail() {
        String vocablesVersion = "1234567A_3";
        VocableVersionParser parser = new VocableVersionParser(vocablesVersion);
        parser.parse();
        assertFalse(parser.isSuccess());
        assertEquals("Da der vordere Teil (1234567A) der Version '1234567A_3' nicht nur aus "
                + "Ziffern besteht, wird sie nicht berücksichtigt.",
                parser.getFailReason());

        assertEquals(-1, parser.getNumber());
        assertEquals("", parser.getDateAsString());
    }

    @Test
    void rearNotOnlyDigitsFail() {
        String vocablesVersion = "12345678_3A";
        VocableVersionParser parser = new VocableVersionParser(vocablesVersion);
        parser.parse();
        assertFalse(parser.isSuccess());
        assertEquals("Da der hintere Teil (3A) der Version '12345678_3A' nicht nur aus Ziffern "
                + "besteht, wird sie nicht berücksichtigt.",
                parser.getFailReason());

        assertEquals(-1, parser.getNumber());
        assertEquals("", parser.getDateAsString());
    }

    @Test
    void normalCase() {
        String vocablesVersion = "20241005_1";
        VocableVersionParser parser = new VocableVersionParser(vocablesVersion);
        parser.parse();
        assertTrue(parser.isSuccess());
        assertEquals("",
                parser.getFailReason());

        assertEquals(1, parser.getNumber());
        assertEquals("20241005", parser.getDateAsString());
        assertEquals("05.10.2024", parser.getDate().toString());

    }

}
