package de.duehl.vocabulary.japanese.logic.internal;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Dieses Interface steht für ein Objekt, das zu einer Vokabel die internen, benutzerabhängigen
 * Daten abrufen kann.
 *
 * @version 1.01     2023-10-20
 * @author Christian Dühl
 */

public interface InternalDataRequester {

    /**
     * Gibt die internen Daten zur übergebenen Vokabel zurück.
     *
     * Sind zu der Vokabel keine internen Daten hinterlegt, so wird eine Ausnahme geworfen.
     *
     * @param vocable
     *            Die Vokabel zu der man die internen Daten ermitteln möchte.
     * @return Die internen Daten zur übergebenen Vokabel.
     */
    InternalAdditionalVocableData getInternalDataForVocable(Vocable vocable);

}
