package de.duehl.vocabulary.japanese.logic.translation.data;

import java.util.Objects;

/**
 * Diese Klasse stellt die Kombination von Kana und Kanji dar.
 *
 * @version 1.01     2024-08-21
 * @author Christian Dühl
 */

public class KanaAndKanji {

    /** Die Vokabel in Hiragana oder Katakana. */
    private final String kana;

    /** Das Wort als Kanji. */
    private final String kanji;

    /**
     * Konstruktor.
     *
     * @param kana
     *            Die Vokabel in Hiragana oder Katakana.
     * @param kanji
     *            Das Wort als Kanji.
     */
    public KanaAndKanji(String kana, String kanji) {
        this.kana = kana;
        this.kanji = kanji;
    }

    /** Getter für die Vokabel in Hiragana oder Katakana. */
    public String getKana() {
        return kana;
    }

    /** Getter für das Wort als Kanji. */
    public String getKanji() {
        return kanji;
    }

    @Override
    public String toString() {
        return "KanaAndKanji [kana=" + kana + ", kanji=" + kanji + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(kana, kanji);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        KanaAndKanji other = (KanaAndKanji) obj;
        return Objects.equals(kana, other.kana) && Objects.equals(kanji, other.kanji);
    }

}
