package de.duehl.vocabulary.japanese.logic.view;

import java.awt.Image;
import java.awt.Point;
import java.util.List;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.CompleteVocabularyViewerDialog;

/**
 * Diese Klasse zeigt alle Vokabeln eines Vokabulars nacheinander an.
 *
 * Momentan ist diese Klasse schlicht überflüssig, aber ich belasse sie erstmal.
 *
 * @version 1.01     2025-09-22
 * @author Christian Dühl
 */

public class CompleteVocabularyViewerLogic {

    /** Der zu dieser Klasse gehörige Dialog, also die grafische Oberfläche der Abfrage. */
    private final CompleteVocabularyViewerDialog dialog;

    /**
     * Konstruktor.
     *
     * @param options
     *            Die Programmoptionen.
     * @param requester
     *            Das Objekt das zu einer Vokabel die internen, benutzerabhängigen Daten abrufen
     *            kann.
     * @param vocables
     *            Die Liste mit den abzufragenden Vokabeln.
     * @param kanjiRequester
     *            Das Objekt, das zu einem Kanji die internen, benutzerabhängigen Daten abrufen
     *            kann.
     * @param description
     *            Die Beschreibung der Menge von Vokabeln.
     * @param informer
     *            Die Oberfläche, welche diese Klasse aufruft, auf der man eine GlassPane anzeigen
     *            kann.
     * @param ownLists
     *            Die Verwaltung der eigenen Vokabellisten.
     * @param messageSetter
     *            Das Objekt, welches in der Statusbar der Gui eine Nachricht anzeigen kann.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Anzuzeigendes ProgrammIcon.
     */
    public CompleteVocabularyViewerLogic(Options options, InternalDataRequester requester,
            List<Vocable> vocables, InternalKanjiDataRequester kanjiRequester, String description,
            LongTimeProcessInformer informer, OwnLists ownLists, MessageSetter messageSetter,
            Point parentLocation, Image programImage) {
        dialog = new CompleteVocabularyViewerDialog(vocables, description, requester,
                kanjiRequester, options, informer, ownLists, messageSetter, parentLocation,
                programImage);
    }

    /** Führt den Test des Vokabulars durch. */
    public void view() {
        dialog.setVisible(true);
    }

}
