package de.duehl.vocabulary.japanese.ui.data;

import java.util.List;

import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Dieses Interface steht für ein Objekt, das alle Vokabeln finden kann, welche einer bestimmten
 * Bedingung entsprechen.
 *
 * @version 1.01     2024-10-26
 * @author Christian Dühl
 */

public interface VocablesWithSpecificConstraintFinder {

    /**
     * Findet alle Vokabeln, die einer bestimmten Bedingung genügen.
     *
     * @param constraint
     *            Die Bedingung, dies kann z.B. ein Suchbegriff oder eine Wortart sein.
     * @return Die Liste mit den Vokabeln, die der Bedingung genügen.
     */
    List<Vocable> findVocablesWithSpecificConstraint(String constraint);

}
