package de.duehl.vocabulary.japanese.ui.dialog.detail.addtolist;

import java.awt.Image;
import java.awt.Point;

import javax.swing.JPanel;

import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;

/**
 * Diese Klasse stellt einen Button bereit, um die veränderliche Vokabel zu einer eigenen Liste
 * hinzuzufügen.
 *
 * @version 1.01     2025-07-14
 * @author Christian Dühl
 */

public class VocableToOwnListAdderWithChangingVocableGui {

    /** Fügt eine Vokabel zu einer eigenen Liste hinzu. */
    private final VocableToOwnListAdder vocableToOwnListAdder;

    /** Der Panel mit dem Button. */
    private final JPanel buttonPanel;

    /**
     * Konstruktor.
     *
     * @param ownLists
     *            Die Verwaltung der eigenen Vokabellisten.
     * @param location
     *            Die Position des Rahmens der Oberfläche, die den Panel anzeigt, welcher diese
     *            Klasse verwendet.
     * @param programImage
     *            Das Icon für das Programm.
     */
    public VocableToOwnListAdderWithChangingVocableGui(OwnLists ownLists, Point location,
            Image programImage) {
        vocableToOwnListAdder = new VocableToOwnListAdder(ownLists, location, programImage);

        buttonPanel = new JPanel();
        buttonPanel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
    }

    /**
     * Fügt zum übergebenen Panel einen Button zur Anzeige der eigenen Listen an, welche die
     * Vokabel enthalten.
     *
     * @param panel
     *            Der Panel dem die Buttons hinzugefügt werden sollen. Dieser sollte ein Layout
     *            haben, das das Hinzufügen von Elemente ohne weitere Parameter gestattet, wie z.B.
     *            das VerticalLayout.
     */
    public void appendButtonToPanel(JPanel panel) {
        panel.add(buttonPanel);
    }

    /** Setter für die Vokabel. */
    public void setVocable(Vocable vocable) {
        updateButtonPanel(vocable);
    }

    private void updateButtonPanel(Vocable vocable) {
        VocableToOwnListAdderButtonCreator creator =
                new VocableToOwnListAdderButtonCreator(vocable, vocableToOwnListAdder);

        buttonPanel.removeAll();
        buttonPanel.add(creator.createAddVocableToListButton());
    }

}
