package de.duehl.vocabulary.japanese.ui.dialog.detail.findlists;

import java.awt.Component;
import java.awt.Point;

import javax.swing.JPanel;

import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;

/**
 * Diese Klasse stellt einen Button bereit, um zu einer Vokabel alle eigenen Listen zu finden und
 * anzuzeigen, die diese Vokabel enthalten.
 *
 * @version 1.01     2025-07-14
 * @author Christian Dühl
 */

public class ListsWithVocableFinderGui {

    /** Findet zu einer Vokabel alle Listen, die diese Vokabel enthalten. */
    private final ListsWithVocableFinder listsWithVocableFinder;

    /** Stellt den Button wirklich dar. */
    private final ListsWithVocableFinderButtonCreator creator;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die angezeigte Vokabel.
     * @param ownLists
     *            Die Verwaltung der eigenen Vokabellisten.
     * @param thisPanelUsingDialog
     *            Der modale oder nicht modale Dialog bzw., Frame, der den Panel nutzt, welcher
     *            diese Klasse verwendet.
     * @param location
     *            Die Position des Rahmens der Oberfläche, die den Panel anzeigt, welcher diese
     *            Klasse verwendet.
     */
    public ListsWithVocableFinderGui(Vocable vocable, OwnLists ownLists,
            Component thisPanelUsingDialog, Point location) {
        listsWithVocableFinder = new ListsWithVocableFinder(ownLists, thisPanelUsingDialog,
                location);
        creator = new ListsWithVocableFinderButtonCreator(vocable, listsWithVocableFinder);
    }

    /**
     * Fügt zum übergebenen Panel einen Button zur Anzeige der eigenen Listen an, welche die
     * Vokabel enthalten.
     *
     * @param panel
     *            Der Panel dem der Button hinzugefügt werden sollen. Dieser sollte ein Layout
     *            haben, das das Hinzufügen von Elemente ohne weitere Parameter gestattet, wie z.B.
     *            das VerticalLayout.
     */
    public void appendButtonToPanel(JPanel panel) {
        panel.add(creator.createFindListsWithVocableButton());
    }

}
