package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;

/**
 * Diese Klasse zeigt die Details eines Kanji inklusive der internen Daten des Benutzers an.
 *
 * @version 1.01     2024-11-29
 * @author Christian Dühl
 */

public class KanjiDetailDialog extends ModalDialogBase {

    private static final int MIN_WIDTH = 700;


    /** Das UI-Komponente, auf der die Daten des Kanji dargestellt werden. */
    private final KanjiPanel kanjiPanel;

    /** Der Button zum Beenden. */
    private final JButton okButton;

    /**
     * Konstruktor.
     *
     * @param kanji
     *            Das anzuzeigende Kanji.
     * @param requester
     *            Das Objekt das zu einem Kanji die internen, benutzerabhängigen Daten abrufen
     *            kann.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Anzuzeigendes ProgrammIcon.
     */
    public KanjiDetailDialog(Kanji kanji, InternalKanjiDataRequester requester,
            Point parentLocation, Image programImage) {
        super(parentLocation, programImage, "Details des zu " + kanji.getCharacter());
        addEscapeBehaviour();

        kanjiPanel = new KanjiPanel();
        kanjiPanel.showKanjiAsViewerToo();
        kanjiPanel.showInternalKanjiDataToo(requester);
        kanjiPanel.createGui();
        kanjiPanel.showKanji(kanji);

        okButton = new JButton("Beenden");

        init();
        fillDialog();
    }

    private void init() {
        okButton.addActionListener(e -> closeDialog());
    }

    @Override
    protected void populateDialog() {
        add(createDummyWidthLabel(), BorderLayout.NORTH);
        add(createCenterPart(), BorderLayout.CENTER);
        add(createButtonsPart(),  BorderLayout.SOUTH);

        SwingUtilities.invokeLater(() -> okButton.requestFocus());
    }

    private Component createDummyWidthLabel() {
        JLabel label = new JLabel("");
        label.setPreferredSize(new Dimension(MIN_WIDTH, 0));
        return label;
    }

    private Component createCenterPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
        GuiTools.createTitle(panel);

        panel.add(kanjiPanel.getPanel());

        return panel;
    }

    private Component createButtonsPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(okButton, BorderLayout.EAST);

        return panel;
    }

}
