package de.duehl.vocabulary.japanese.ui.filter;

import de.duehl.swing.ui.components.selections.data.SearchWordSelectionInputs;

/**
 * Diese Klasse stellt die Suchparameter der erweiterten Suche dar. Diese werden zwischen zwei
 * erweiterten Suchen in der gleichen Sitzung in einem Objekt dieser Klasse gespeichert.
 *
 * @version 1.01     2024-08-22
 * @author Christian Dühl
 */

public class VocableFilterInputs {

    private int categoryFilterComboBoxIndex;
    private int subCategoryFilterComboBoxIndex;
    private int vocabularyDescriptionFilterComboBoxIndex;
    private int searchWordFilterComboBoxIndex;
    private int partsOfSpeechFilterComboBoxIndex;

    private SearchWordSelectionInputs kanaSearchFilterInputs;
    private SearchWordSelectionInputs kanjiSearchFilterInputs;
    private SearchWordSelectionInputs romajiSearchFilterInputs;
    private SearchWordSelectionInputs pronunciationSearchFilterInputs;
    private SearchWordSelectionInputs translationSearchFilterInputs;
    private SearchWordSelectionInputs commentSearchFilterInputs;
    private SearchWordSelectionInputs searchWordSearchFilterInputs;
    private SearchWordSelectionInputs partOfSpeechSearchFilterInputs;
    private SearchWordSelectionInputs searchFilterInputs;

    public VocableFilterInputs() {
        categoryFilterComboBoxIndex = 0;
        subCategoryFilterComboBoxIndex = 0;
        vocabularyDescriptionFilterComboBoxIndex = 0;
        searchWordFilterComboBoxIndex = 0;
        partsOfSpeechFilterComboBoxIndex = 0;

        kanaSearchFilterInputs = new SearchWordSelectionInputs();
        kanjiSearchFilterInputs = new SearchWordSelectionInputs();
        romajiSearchFilterInputs = new SearchWordSelectionInputs();
        pronunciationSearchFilterInputs = new SearchWordSelectionInputs();
        translationSearchFilterInputs = new SearchWordSelectionInputs();
        commentSearchFilterInputs = new SearchWordSelectionInputs();
        searchWordSearchFilterInputs = new SearchWordSelectionInputs();
        partOfSpeechSearchFilterInputs = new SearchWordSelectionInputs();
        searchFilterInputs = new SearchWordSelectionInputs();
    }

    public int getCategoryFilterComboBoxIndex() {
        return categoryFilterComboBoxIndex;
    }

    public void setCategoryFilterComboBoxIndex(int categoryFilterComboBoxIndex) {
        this.categoryFilterComboBoxIndex = categoryFilterComboBoxIndex;
    }

    public int getSubCategoryFilterComboBoxIndex() {
        return subCategoryFilterComboBoxIndex;
    }

    public void setSubCategoryFilterComboBoxIndex(int subCategoryFilterComboBoxIndex) {
        this.subCategoryFilterComboBoxIndex = subCategoryFilterComboBoxIndex;
    }

    public int getVocabularyDescriptionFilterComboBoxIndex() {
        return vocabularyDescriptionFilterComboBoxIndex;
    }

    public void setVocabularyDescriptionFilterComboBoxIndex(
            int vocabularyDescriptionFilterComboBoxIndex) {
        this.vocabularyDescriptionFilterComboBoxIndex = vocabularyDescriptionFilterComboBoxIndex;
    }

    public int getSearchWordFilterComboBoxIndex() {
        return searchWordFilterComboBoxIndex;
    }

    public void setSearchWordFilterComboBoxIndex(int searchWordFilterComboBoxIndex) {
        this.searchWordFilterComboBoxIndex = searchWordFilterComboBoxIndex;
    }

    public int getPartsOfSpeechFilterComboBoxIndex() {
        return partsOfSpeechFilterComboBoxIndex;
    }

    public void setPartsOfSpeechFilterComboBoxIndex(int partsOfSpeechFilterComboBoxIndex) {
        this.partsOfSpeechFilterComboBoxIndex = partsOfSpeechFilterComboBoxIndex;
    }

    public SearchWordSelectionInputs getKanaSearchFilterInputs() {
        return kanaSearchFilterInputs;
    }

    public void setKanaSearchFilterInputs(SearchWordSelectionInputs kanaSearchFilterInputs) {
        this.kanaSearchFilterInputs = kanaSearchFilterInputs;
    }

    public SearchWordSelectionInputs getKanjiSearchFilterInputs() {
        return kanjiSearchFilterInputs;
    }

    public void setKanjiSearchFilterInputs(SearchWordSelectionInputs kanjiSearchFilterInputs) {
        this.kanjiSearchFilterInputs = kanjiSearchFilterInputs;
    }

    public SearchWordSelectionInputs getRomajiSearchFilterInputs() {
        return romajiSearchFilterInputs;
    }

    public void setRomajiSearchFilterInputs(SearchWordSelectionInputs romajiSearchFilterInputs) {
        this.romajiSearchFilterInputs = romajiSearchFilterInputs;
    }

    public SearchWordSelectionInputs getPronunciationSearchFilterInputs() {
        return pronunciationSearchFilterInputs;
    }

    public void setPronunciationSearchFilterInputs(
            SearchWordSelectionInputs pronunciationSearchFilterInputs) {
        this.pronunciationSearchFilterInputs = pronunciationSearchFilterInputs;
    }

    public SearchWordSelectionInputs getTranslationSearchFilterInputs() {
        return translationSearchFilterInputs;
    }

    public void setTranslationSearchFilterInputs(
            SearchWordSelectionInputs translationSearchFilterInputs) {
        this.translationSearchFilterInputs = translationSearchFilterInputs;
    }

    public SearchWordSelectionInputs getCommentSearchFilterInputs() {
        return commentSearchFilterInputs;
    }

    public void setCommentSearchFilterInputs(SearchWordSelectionInputs commentSearchFilterInputs) {
        this.commentSearchFilterInputs = commentSearchFilterInputs;
    }

    public SearchWordSelectionInputs getSearchWordSearchFilterInputs() {
        return searchWordSearchFilterInputs;
    }

    public void setSearchWordSearchFilterInputs(
            SearchWordSelectionInputs searchWordSearchFilterInputs) {
        this.searchWordSearchFilterInputs = searchWordSearchFilterInputs;
    }

    public SearchWordSelectionInputs getPartOfSpeechSearchFilterInputs() {
        return partOfSpeechSearchFilterInputs;
    }

    public void setPartOfSpeechSearchFilterInputs(
            SearchWordSelectionInputs partOfSpeechSearchFilterInputs) {
        this.partOfSpeechSearchFilterInputs = partOfSpeechSearchFilterInputs;
    }

    public SearchWordSelectionInputs getSearchFilterInputs() {
        return searchFilterInputs;
    }

    public void setSearchFilterInputs(SearchWordSelectionInputs searchFilterInputs) {
        this.searchFilterInputs = searchFilterInputs;
    }

}
