package de.duehl.vocabulary.japanese.ui.listcommander.selector.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JPanel;

import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;

/**
 * Diese Klasse stellt den Dialog für die Historie eines Auswahl-Elements für eigene Listen dar.
 *
 * @version 1.01     2025-07-04
 * @author Christian Dühl
 */

public class OwnListHistoryDialog extends ModalDialogBase {

    /**
     * Die zuletzt verwendeten eigenen Listen, auf die neuste davon wird der Selektor gestellt,
     * wenn die Liste bekannt ist. Sie werden auch in der Historie angezeigt.
     */
    private final HistoricalOwnListPersistanceDataList historicalOwnLists;

    /** Gibt an, ob der Benutzer einen der historischen Einträge ausgewählt hat. */
    private boolean validSelection;

    /** Die vom Benutzer ausgewählte eigene Liste. */
    private OwnListPersistanceData selectedPersistentOwnList;

    /**
     * Konstruktor.
     *
     * @param historicalOwnLists
     *            Die zuletzt verwendeten eigenen Listen, auf die neuste davon wird der Selektor
     *            gestellt, wenn die Liste bekannt ist. Sie werden auch in der Historie angezeigt.
     * @param parentLocation
     *            Die Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Das Icon für das Programm.
     */
    public OwnListHistoryDialog(HistoricalOwnListPersistanceDataList historicalOwnLists,
            Point parentLocation, Image programImage) {
        super(parentLocation, programImage, "Historie der eigenen Listen");
        addEscapeBehaviour();

        this.historicalOwnLists = historicalOwnLists;

        validSelection = false;

        fillDialog();
    }

    /** Erstellt die grafische Oberfläche. */
    @Override
    protected void populateDialog() {
        add(createHistoricalPart(), BorderLayout.CENTER);
        /*
         * TODO
         *
         * ggf. mit Scrollpane bei zu vielen Einträgen... Dann muss man aber eine Größe vorgeben.
         */
    }

    private Component createHistoricalPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(2, VerticalLayout.BOTH));

        List<OwnListPersistanceData> persistentOwnLists = historicalOwnLists.getHistoricalOwnLists();
        for (OwnListPersistanceData persistentOwnList : persistentOwnLists) {
            panel.add(createPersistentOwnListButton(persistentOwnList));
        }

        return panel;
    }

    private Component createPersistentOwnListButton(OwnListPersistanceData persistentOwnList) {
        String text = persistentOwnList.getCategory() + " - " + persistentOwnList.getSubCategory()
                + " - " + persistentOwnList.getName();
        JButton button = new JButton(text);
        button.addActionListener(e -> selectList(persistentOwnList));
        return button;
    }

    private void selectList(OwnListPersistanceData persistentOwnList) {
        validSelection = true;
        selectedPersistentOwnList = persistentOwnList;
        closeDialog();
    }

    /** Gibt an, ob der Benutzer einen der historischen Einträge ausgewählt hat. */
    public boolean isValidSelection() {
        return validSelection;
    }

    /** Getter für die vom Benutzer ausgewählte eigene Liste. */
    public OwnListPersistanceData getSelectedPersistentOwnList() {
        return selectedPersistentOwnList;
    }

}
