package de.duehl.vocabulary.japanese.website.update.ownlists.data;

import java.util.List;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;

/**
 * Diese Klasse stellt die Daten einer Zeile aus der Datei Neuste_Version_Listen.txt (ob nun lokal
 * im Falle des Uploads oder von der Webseite heruntergeladen im Falle der Überprüfung auf
 * Neuerungen) dar.
 *
 * @version 1.01     2024-10-24
 * @author Christian Dühl
 */

public class NewestOwnListVersionListEntry {

    /** Der Gruppenname ("FROM_ZERO_1"). */
    private final String groupName;

    /** Die Nummer der Version ("17"). */
    private int version;

    /**
     * Konstruktor.
     *
     * @param groupName
     *            Der Gruppenname ("FROM_ZERO_1").
     * @param version
     *            Die Nummer der Version ("17").
     */
    public NewestOwnListVersionListEntry(String groupName, int version) {
        this.groupName = groupName;
        this.version = version;
    }

    /** Getter für den Gruppennamen ("FROM_ZERO_1"). */
    public String getGroupName() {
        return groupName;
    }

    /** Getter für die Nummer der Version ("17"). */
    public int getVersion() {
        return version;
    }

    /** Setter für die Nummer der Version ("17"). */
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "NewestOwnListVersionListEntry [groupName=" + groupName + ", version=" + version
                + "]";
    }

    /**
     * Erzeugt eine Zeile, wie sie in die Datei Neuste_Version_Listen.txt geschrieben werden soll.
     */
    public String createLine() {
        return groupName + " : " + version;
    }

    /**
     * Erzeugt ein NewestOwnListVersionListEntry-Objekt aus einer Zeile der Datei
     * Neuste_Version_Listen.txt.
     */
    public static NewestOwnListVersionListEntry createFromLine(String line) {
        List<String> parts = Text.splitByColon(line);
        if (parts.size() != 2) {
            throw new RuntimeException(
                    "Die Zeile lässt sich nicht an ':' in zwei Teile teilen.");
        }

        String groupName = parts.get(0);
        String versionString = parts.get(1);

        groupName = groupName.strip();
        versionString = versionString.strip();

        int version = NumberString.parseInt(versionString);

        return new NewestOwnListVersionListEntry(groupName, version);
    }

}
