package de.duehl.vocabulary.japanese.io;

import org.junit.jupiter.api.Test;

import de.duehl.vocabulary.japanese.data.Vocable;

import static org.junit.jupiter.api.Assertions.*;

import java.util.List;

public class VocabularyReaderTest {

    @Test
    public void test1() {
        String filename = "c:/Users/setup/Daten/sprachen/japanisch/vokabeln/"
                + "Vokabeln_Japanese_From_Zero_1/Vokabeln_B1_K05_4_B)_Bett_und_Bad.voc";
        VocabularyReader reader = new VocabularyReader(filename);
        reader.read();
        List<Vocable> vocables = reader.getVocables();
        assertFalse(vocables.isEmpty());
        //System.out.println(vocables);

        Vocable vocable = vocables.get(0);
        assertEquals("まくら", vocable.getKana());
        assertEquals("枕", vocable.getKanji());
        assertEquals("makura", vocable.getRomaji());
        assertEquals("maküra", vocable.getPronunciation());
        List<String> translations = vocable.getTranslations();
        assertEquals(2, translations.size());
        assertEquals("Kopfkissen", translations.get(0));
        assertEquals("Kissen", translations.get(1));
        assertEquals("makura_枕.mp3", vocable.getBareMp3());
        assertEquals("", vocable.getMp3());
        assertEquals("", vocable.getComment());

        String category = reader.getVocabularyCategory();
        assertEquals("From Zero 1", category);

        String subCategory = reader.getVocabularySubCategory();
        assertEquals("From Zero 1 Groups", subCategory);
    }

}
