package de.duehl.vocabulary.japanese.website.update.ownlists;

import org.junit.jupiter.api.Test;

import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.parser.NewestOwnListsVersionParser;

import static org.junit.jupiter.api.Assertions.*;

import java.util.List;

public class NewestOwnListsVersionParserTest {

    @Test
    void emptyFileTest() {
        String content = """
                """;

        NewestOwnListsVersionParser parser = new NewestOwnListsVersionParser(content);
        parser.parse();
        assertTrue(parser.isSuccess());
        assertEquals("", parser.getFailReason());
        List<NewestOwnListVersionListEntry> entries = parser.getNewestOwnListVersionListEntries();
        assertEquals(0, entries.size());
    }

    @Test
    void initialFileTest() {
        String content = """
                FROM_ZERO_1 : 0
                FROM_ZERO_2 : 0
                FROM_ZERO_3 : 0
                SCHRITT_FUER_SCHRITT_1 : 0
                VHS_A1_1 : 0
                VHS_A1_2 : 0
                MARUGOTO_A1 : 0
                """;

        NewestOwnListsVersionParser parser = new NewestOwnListsVersionParser(content);
        parser.parse();
        assertTrue(parser.isSuccess());
        assertEquals("", parser.getFailReason());
        List<NewestOwnListVersionListEntry> entries = parser.getNewestOwnListVersionListEntries();
        assertEquals(7, entries.size());

        NewestOwnListVersionListEntry entry1 = entries.get(0);
        NewestOwnListVersionListEntry entry2 = entries.get(1);
        NewestOwnListVersionListEntry entry3 = entries.get(2);
        NewestOwnListVersionListEntry entry4 = entries.get(3);
        NewestOwnListVersionListEntry entry5 = entries.get(4);
        NewestOwnListVersionListEntry entry6 = entries.get(5);
        NewestOwnListVersionListEntry entry7 = entries.get(6);

        assertEquals("FROM_ZERO_1", entry1.getGroupName());
        assertEquals(0, entry1.getVersion());

        assertEquals("FROM_ZERO_2", entry2.getGroupName());
        assertEquals(0, entry2.getVersion());

        assertEquals("FROM_ZERO_3", entry3.getGroupName());
        assertEquals(0, entry3.getVersion());

        assertEquals("SCHRITT_FUER_SCHRITT_1", entry4.getGroupName());
        assertEquals(0, entry4.getVersion());

        assertEquals("VHS_A1_1", entry5.getGroupName());
        assertEquals(0, entry5.getVersion());

        assertEquals("VHS_A1_2", entry6.getGroupName());
        assertEquals(0, entry6.getVersion());

        assertEquals("MARUGOTO_A1", entry7.getGroupName());
        assertEquals(0, entry7.getVersion());
    }

    @Test
    void missingColon() {
        String content = """
                FROM_ZERO_1 : 1
                FROM_ZERO_2 : 1
                FROM_ZERO_3 : 1
                SCHRITT_FUER_SCHRITT_1 ; 1
                VHS_A1_1 : 1
                VHS_A1_2 : 1
                MARUGOTO_A1 : 1
                """;

        NewestOwnListsVersionParser parser = new NewestOwnListsVersionParser(content);
        parser.parse();
        assertFalse(parser.isSuccess());
        assertEquals("Die Zeile 'SCHRITT_FUER_SCHRITT_1 ; 1' lässt sich nicht parsen: "
                + "Die Zeile lässt sich nicht an ':' in zwei Teile teilen.",
                parser.getFailReason());
        List<NewestOwnListVersionListEntry> entries = parser.getNewestOwnListVersionListEntries();
        assertEquals(0, entries.size());
    }

    @Test
    void notOnlyDigits() {
        String content = """
                FROM_ZERO_1 : 1
                FROM_ZERO_2 : 1
                FROM_ZERO_3 : 1
                SCHRITT_FUER_SCHRITT_1 : 1
                VHS_A1_1 : 1
                VHS_A1_2 : 1
                MARUGOTO_A1 : 1.1
                """;

        NewestOwnListsVersionParser parser = new NewestOwnListsVersionParser(content);
        parser.parse();
        assertFalse(parser.isSuccess());
        assertEquals("Die Zeile 'MARUGOTO_A1 : 1.1' lässt sich nicht parsen: Lässt sich nicht "
                + "als Integer parsen: '1.1'",
                parser.getFailReason());
        List<NewestOwnListVersionListEntry> entries = parser.getNewestOwnListVersionListEntries();
        assertEquals(0, entries.size());
    }

}
