package de.duehl.basics.autodetect.ent.single;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.autodetect.ent.EntWorker;

/**
 * Diese Klasse ist die abstrakte Basis einer Klasse, welche im Text (ent) einen Begriff einer Art
 * findet und diesen, so gefunden, in einer Variablen vorhält. Dabei wird der gefundene Begriff in
 * ent durch einen Platzhalter ersetzt und ein Kommentar zur Auffindung des Begriffs gesammelt.
 *
 * @version 1.01     2022-05-06
 * @author Christian Dühl
 */

public abstract class SingleEntityReplacer extends EntWorker {

    /** Platzhalter in der Form <<street>>. */
    protected final String placeholder;

    /** Der hier gefundene Wert. Wird keiner gefunden, ist es der leere String. */
    protected String value;

    /**
     * Konstruktor.
     *
     * @param ent
     *            Ursprünglich der rohe Text, dieser wird/wurde bei der Analyse aber verändert und
     *            Teile durch die Entitäten wie <<street>> ersetzt.
     * @param placeholder
     *            Der Platzhalter in der Form <<street>>, durch den der gefundene Begriff ersetzt
     *            wird.
     */
    public SingleEntityReplacer(String ent, String placeholder) {
        super(ent);
        this.ent = ent;
        this.placeholder = placeholder;
        value = "";
    }

    /** Sucht, merkt und ersetzt in ent. */
    public abstract void replace();

    /**
     * Getter für den hier gefundenen Wert.
     *
     * Wird keiner gefunden, wird der leere String zurückgegeben.
     */
    public String getValue() {
        return value;
    }

}
