package de.duehl.basics.io.textfile;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.Reader;

/**
 * Diese Klasse liest eine Text-Datei ein.
 *
 * @version 1.01     2019-05-14
 * @author Christian Dühl
 */

public class FullNormalTextFileReader extends FullTextFileReader {

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der einzulesenden Datei.
     * @param charset
     *            Kodierung der einzulesenden Datei.
     */
    public FullNormalTextFileReader(String filename, Charset charset) {
        super(filename, charset);
    }

    /** Öffnet den Reader zum Einlesen der Datei. */
    @Override
    protected Reader openReader() {
        return new FineFileReader(filename, charset);
    }

}
