package de.duehl.basics.logic;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse ist die einfachste Umsetzung des Interface ErrorHandler.
 * Die Ausgaben erfolgen einfach nach STDOUT.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public class PrintErrorHandler implements ErrorHandler {

    /** Gibt eine Warnung aus. */
    @Override
    public void warning(String message) {
        System.out.println("WARNING: " + message);
    }

    /**
     * Gibt einen Fehler aus.
     *
     * @param message
     *            Text der Fehlermeldung.
     */
    @Override
    public void error(String message) {
        System.out.println("ERROR: " + message);
    }

    /**
     * Zeigt dem Benutzer einen Fehler mit Exception an.
     *
     * @param message
     *            Text der Fehlermeldung.
     * @param exception
     *            Aufgetretene Ausnahme.
     */
    @Override
    public void error(String message, Exception exception) {
        System.out.println("ERROR: " + message);
        exception.printStackTrace(System.out);
    }

}
