package de.duehl.basics.text;

/**
 * Diese Enum-Klasse stellt den Trenner der Zeilen der Eingangsdatei dar.
 *
 * @version 1.01     2019-07-16
 * @author Christian Dühl
 */

public enum Separator {

    TABULATOR("\t"),
    PIPE("\\|"),
    ;

    /** Regulärer Ausdruck zum Trennen der Zeilen. */
    private final String regex;

    private Separator(String regex) {
        this.regex = regex;
    }

    /** Getter für den regulären Ausdruck zum Trennen der Zeilen. */
    public String getRegex() {
        return regex;
    }

    /** Ermittelt das passende Objekt zum angegebenen Namen. */
    public static Separator detectFromNameString(String name) {
        try {
            return Separator.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Es ist kein Separator mit dem Namen '" + name
                    + "' bekannt!");
        }
    }

}
