package de.duehl.basics.datetime.time;

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.system.SystemTools;

public class ContinousTimeMeasurementTest {

    @Test
    public void normalUse() {
        ContinousTimeMeasurement measuring = new ContinousTimeMeasurement();
        measuring.startTimeMeasuring();

        SystemTools.sleep(1000);
        String acutal1 = measuring.timeMeasurement();

        SystemTools.sleep(2000);
        String acutal2 = measuring.timeMeasurement();

        SystemTools.sleep(3000);
        String acutal3 = measuring.timeMeasurement();

        SystemTools.sleep(1000);
        String acutal4 = measuring.timeMeasurement();

        measuring.stopTimeMeasuring();

        assertEquals("00:00:01 (00:00:01 - 1. Messung)", acutal1);
        assertEquals("00:00:03 (00:00:02 -    200,00%)", acutal2);
        assertEquals("00:00:06 (00:00:03 -    300,00%)", acutal3);
        assertEquals("00:00:07 (00:00:01 -    100,00%)", acutal4);
    }

    @Test (expected = RuntimeException.class)
    public void failWithTimeMeasuringAfterStop() {
        ContinousTimeMeasurement measuring = new ContinousTimeMeasurement();
        measuring.startTimeMeasuring();
        measuring.stopTimeMeasuring();
        measuring.timeMeasurement();
    }

}
