package de.duehl.basics.datetime.time.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.system.SystemTools;

public class CountDownWatchTest {

    @Test
    public void createObject() {
        CountDownWatch countDown = new CountDownWatch(0);
        assertNotNull(countDown);
    }

    @Test
    public void getTimeAfterStartInitWithLong() {
        CountDownWatch countDown = new CountDownWatch(2* 60 + 23);
        String actual = countDown.getTime();
        String expected = "00:02:23";
        assertEquals(expected, actual);
    }

    @Test
    public void getTimeAfterStartInitWithText() {
        CountDownWatch countDown = new CountDownWatch("00:02:23");
        String actual = countDown.getTime();
        String expected = "00:02:23";
        assertEquals(expected, actual);
    }

    @Test
    public void getTimeInSecondsAfterStartInitWithLong() {
        CountDownWatch countDown = new CountDownWatch(2* 60 + 23);
        long actual = countDown.getTimeInSeconds();
        long expected = 2* 60 + 23;
        assertEquals(expected, actual);
    }

    @Test
    public void getTimeInSecondsAfterStartInitWithText() {
        CountDownWatch countDown = new CountDownWatch("00:02:23");
        long actual = countDown.getTimeInSeconds();
        long expected = 2* 60 + 23;
        assertEquals(expected, actual);
    }

    @Test
    public void getTimeInSecondsAfter2Seconds() {
        CountDownWatch countDown = new CountDownWatch("00:02:23");

        SystemTools.sleep(2000);

        long actual = countDown.getTimeInSeconds();
        long expected = 2* 60 + 21;
        assertTrue(expected + 1 >= actual
                && expected - 1 <= actual);
    }

}
