package de.duehl.basics.datetime.time.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.system.SystemTools;

public class StopWatchTest {

    @Test
    public void createObject() {
        StopWatch timer = new StopWatch();
        assertNotNull(timer);
    }

    @Test
    public void getTime() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        String time = timer.getTime();
        assertEquals("00:00:02", time);
    }

    @Test
    public void getTimeInSeconds() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        long seconds = timer.getTimeInSeconds();
        assertTrue(1 < seconds);
        assertTrue(3 > seconds);
    }

    @Test
    public void getTimeInMilliSeconds() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        long millis = timer.getTimeInMilliSeconds();
        assertTrue(1995 < millis);
        assertTrue(2050 > millis);
    }

    @Test
    public void getTimeTwoTimes() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        String time = timer.getTime();
        assertEquals("00:00:02", time);

        SystemTools.sleep(2000);
        time = timer.getTime();
        assertEquals("00:00:04", time);
    }

    @Test
    public void getTimeTwoTimesButStopAfterFirst() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        timer.stop();
        String time = timer.getTime();
        assertEquals("00:00:02", time);

        SystemTools.sleep(2000);
        time = timer.getTime();
        assertEquals("00:00:02", time);
    }

    @Test
    public void getTimeInMilliSecondsTwoTimesButStopAfterFirst() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        timer.stop();
        long millis = timer.getTimeInMilliSeconds();
        assertTrue(1995 < millis);
        assertTrue(2050 > millis);

        SystemTools.sleep(2000);
        millis = timer.getTimeInMilliSeconds();
        assertTrue(1995 < millis);
        assertTrue(2050 > millis);
    }

    @Test
    public void getTimeInSecondsTwoTimesButStopAfterFirst() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        timer.stop();
        long seconds = timer.getTimeInSeconds();
        assertTrue(1 < seconds);
        assertTrue(3 > seconds);

        SystemTools.sleep(2000);
        seconds = timer.getTimeInSeconds();
        assertTrue(1 < seconds);
        assertTrue(3 > seconds);
    }

    @Test
    public void toStringTest() {
        StopWatch timer = new StopWatch();

        SystemTools.sleep(2000);
        String actual = timer.toString();
        String expected = "StopWatch [00:00:02]";
        assertEquals(expected, actual);
    }

    @Test
    public void getTimeStartStopWaitStart() {
        StopWatch timer = new StopWatch();    // start

        SystemTools.sleep(2000);
        String time = timer.getTime();
        assertEquals("00:00:02", time);

        timer.stop();                         // stop
        SystemTools.sleep(2000);              // wait
        time = timer.getTime();
        assertEquals("00:00:02", time);

        timer.start();                        // start
        SystemTools.sleep(2000);
        time = timer.getTime();
        assertEquals("00:00:02", time);
    }

    @Test
    public void getTimeStartStopWaitRestart() {
        StopWatch timer = new StopWatch();    // start

        SystemTools.sleep(2000);
        String time = timer.getTime();
        assertEquals("00:00:02", time);

        timer.stop();                         // stop
        SystemTools.sleep(2000);              // wait
        time = timer.getTime();
        assertEquals("00:00:02", time);

        timer.restart();                      // restart
        SystemTools.sleep(2000);
        time = timer.getTime();
        assertEquals("00:00:04", time);
    }

}
