package de.duehl.html.download.data;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt steht für die Art des Redirect-Handlings.
 *
 * @version 1.01     2017-05-18
 * @author Christian Dühl
 */

public enum RedirectHandling {

    STANDARD(false),
    LAX(false),
    NONE(true),
    ;

    /** Gibt an, ob der Aufrufer sich selbst um die Redirects kümmert. */
    private final boolean redirectHandledByCaller;

    private RedirectHandling(boolean redirectHandledByCaller) {
        this.redirectHandledByCaller = redirectHandledByCaller;
    }

    public boolean isRedirectHandledByCaller() {
        return redirectHandledByCaller;
    }

}
