package de.duehl.swing.ui.buttons.creator;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

import javax.swing.JButton;

/**
 * Diese Klasse erstellt ganz gewöhnliche Buttons.
 *
 * @version 1.01     2021-05-07
 * @author Christian Dühl
 */

public class StandardButtonCreator implements ButtonCreator {

    /**
     * Erstellt einen Button mit der passenden Aufschrift und hinterlegt die Aktion für den Klick
     * auf den Button.
     *
     * @param text
     *            Beschriftung des Buttons.
     * @param buttonClickAction
     *            Aktion die bei einem Klick auf den Button ausgeführt wird.
     */
    @Override
    public Component createButton(String text, Runnable buttonClickAction) {
        JButton button = new JButton(text);
        button.addActionListener(e -> buttonClickAction.run());
        return button;
    }

}
