package de.duehl.swing.ui.components.elements;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.text.DecimalFormat;

import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

/**
 * Diese Klasse stellt ein Element mit einer Überschrift oben und einem frei bearbeitbaren,
 * numerischen Text darunter dar.
 *
 * @version 1.01     2019-12-18
 * @author Christian Dühl
 */

public class NumericTextFieldWithTitle extends TextFieldWithTitle {

    public NumericTextFieldWithTitle(String title) {
        super(title);
    }

    @Override
    protected JTextField createTextField() {
        return new JFormattedTextField(
                DecimalFormat.getInstance());
    }

    /** Setzt den numerischen Text des Textfeldes. */
    public void setText(int numericText) {
        setText(Integer.toString(numericText));
    }

}
