package de.duehl.swing.ui.dialogs.lists.ui;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableListElement;

/**
 * Dieses Interface stellt einen reduzierten Methodensatz des EditableListDialog dar, mit dem
 * Elemente angezeigt, bearbeitet, gelöscht, umsortiert oder neu hinzugefügt werden kann.
 *
 * @version 1.02     2021-11-16
 * @author Christian Dühl
 */

public interface UiElementListModifier<Element extends LogicalEditableListElement> {

    /** Entfernt das angegebene logische Element aus der Liste. */
    void removeElementFromList(Element element);

    /** Aktualisiert die Anzeige der Elemente. */
    void updateElementsPanel();

    /**
     * Gibt die Komponente des Verwaltungsdialogs an, um vor dieser weitere Dialoge positionieren
     * zu können.
     */
    Component getComponent();

}
